% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{layoutCircle}
\alias{layoutCircle}
\alias{layoutCircle,worldNLR,agentMatrix,numeric-method}
\title{Layout \code{turtles} on a circle}
\usage{
layoutCircle(world, turtles, radius, torus = FALSE)

\S4method{layoutCircle}{worldNLR,agentMatrix,numeric}(world, turtles, radius, torus = FALSE)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{radius}{Numeric. Radius of the circle.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
\code{AgentMatrix} representing the \code{turtles} with updated
coordinates and updated data for their \code{heading} values and
previous coordinates \code{prevX}
and \code{prevY}.
}
\description{
Relocate the \code{turtles} on a circle centered on the \code{world}.
}
\details{
The \code{turtles} point outwards.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If the
     `radius` value leads `turtles` outside of the `world`'s extent
     and `torus = TRUE`, they are
     relocated on the other sides of the `world`, inside its extent; if
     `torus = FALSE`, the `turtles` are located past
     the `world`'s extent.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(
  minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9,
  data = runif(100)
)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
plot(w1)
points(t1, col = "black", pch = 16)

t1 <- layoutCircle(world = w1, turtles = t1, radius = 3)
points(t1, col = "red", pch = 16)

}
\references{
Wilensky, U. 1999. NetLogo. https://www.netlogo.org.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://docs.netlogo.org/dictionary.html#layout-circle}
}
\author{
Sarah Bauduin
}
