% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkGuided.R
\name{NetworkGuided}
\alias{NetworkGuided}
\title{NetworkGuided}
\usage{
NetworkGuided(Y, X, hubs, Z, nfolds = 5)
}
\arguments{
\item{Y}{A continuous outcome variable.}

\item{X}{A data matrix of dimension n x p representing samples (rows) by
features (columns).}

\item{hubs}{A vector of hubs idenfitied through identifyHubs function from
our package.}

\item{Z}{A matrix of clinical or demographic covariates.}

\item{nfolds}{A user-specified numeric value for k-fold cross-validation.}
}
\value{
A vector of network-guided penalized regression coefficients.
}
\description{
A main function to obtain network-guided penalized
regression coefficient estimates.
}
\examples{
library(plsgenomics)
data(Colon) ## Data from plsgenomics R package
X = data.frame(Colon$X[,1:100]) ## The first 100 genes
Z = data.frame(Colon$X[,101:102]) ## Two clinical covariates
colnames(Z) = c("Z1", "Z2")
Y = as.vector(Colon$X[,1000])  ## Continuous outcome variable

## Apply identifyHubs():
preNG = identifyHubs(X=X, delta=0.05, tau=5, ebic.gamma = 0.1)

## Explore preNG results:
hubs = preNG$hubs ## Returns the names of the identified hub nodes.

## Use our main NetworkGuided function, to obtain network-guided
## penalized regression coefficient estimates.
NG = NetworkGuided(Y=Y, X=X, hubs=preNG$hubs, Z=Z, nfolds=5)
NG$coef
}
