% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nematode.ave.mass}
\alias{nematode.ave.mass}
\title{Nematode Genus and Family Average Body Mass}
\format{
A data frame with 987 rows and 4 variables:
\describe{
\item{Genus}{Nematode genus name (character), taxonomically validated against Nemaplex database}
\item{Family}{Corresponding taxonomic family (character)}
\item{Genus.Average.Mass}{Mean dry mass per genus (numeric, \eqn{\mu}g)}
\item{Family.Average.Mass}{Mean dry mass per family (numeric, \eqn{\mu}g)}
}
}
\source{
Nemaplex.UCDavis.edu; Revision Date: 07/08/2025; Accessed 07/16/2025
\itemize{
\item Website: \url{http://nemaplex.ucdavis.edu/}
}
}
\usage{
nematode.ave.mass
}
\description{
A dataset containing the average dry body mass (in micrograms) of nematode genera and families,
compiled from morphological measurements and allometric scaling. Essential for metabolic rate calculations
and size-spectrum analyses in soil ecology.
}
\examples{
# Load data
data(nematode.ave.mass)

# Find mass range within a family (e.g. Rhabditidae)
rhabditidae <- subset(nematode.ave.mass, Family == "Rhabditidae")
range(rhabditidae$Genus.Average.Mass, na.rm = TRUE)

# Convert to biomass (example: 100 individuals of Acanthopharynx)
100 * subset(nematode.ave.mass, Genus == "Acanthopharynx")$Genus.Average.Mass
}
\seealso{
Use \code{\link{nematode.info}} for complementary trait data.
}
\keyword{datasets}
