% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological_indices.R
\name{Ecological.Indices}
\alias{Ecological.Indices}
\alias{Ecological.Indices.data.frame}
\alias{Ecological.Indices.matrix}
\alias{Ecological.Indices.default}
\title{Calculate Ecological Indices of Nematodes}
\usage{
Ecological.Indices(data, indices = "All", method = NULL, ...)

\method{Ecological.Indices}{data.frame}(data, indices = "All", method = NULL, ...)

\method{Ecological.Indices}{matrix}(data, indices = "All", method = NULL, ...)

\method{Ecological.Indices}{default}(data, indices = "All", method = NULL, ...)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance table where rows represent samples and columns represent nematode genera.
Each element indicates the count of a specific nematode genus in the corresponding sample. Row names must be sample names, and column names must be nematode genus names.}

\item{indices}{A character vector specifying the ecological indices to be calculated.
The following indices are supported:
\itemize{
\item "TD" - Trophic Diversity
\item "H" - Shannon-Wiener Index
\item "J" - Pielou's Evenness Index
\item "Simpson" - Simpson Index
\item "WI" - Wasilewska Index
\item "MI" - Maturity Index
\item "PPI" - Plant Parasite Index
\item "SRI" - Species Richness Index
\item "NCR" - Nematode Channel Ratio
\item "CI" - Channel Index
\item "BI" - Basic Index
\item "EI" - Enrichment Index
\item "SI" - Structure Index
}
Additionally, specifying \code{All} will calculate all supported indices. \code{All} is the default value.}

\item{method}{The method to use for calculating the Species Richness Index. Default is \code{NULL}, which uses the default method \code{Margalef}. Options include:
\itemize{
\item \code{"Margalef"}: Margalef's Richness Index, calculated as \eqn{(S - 1) / \ln(N)}.
\item \code{"Menhinick"}: Menhinick's Richness Index, calculated as \eqn{S / \sqrt{N}}.
}}

\item{...}{Additional arguments (currently unused).}
}
\value{
A data frame containing the calculated indices. The data frame includes a \code{Sample.ID} column and additional columns for each requested index.
}
\description{
This function calculates various ecological indices based on the provided nematode genus abundance data.
It supports a range of indices, including taxonomic diversity, Shannon diversity index, Pielou's evenness index,
Simpson's index, and more. Users can specify which indices to calculate or use the default option to calculate all supported indices.
}
\examples{
# Example with a data frame
df <- data.frame(
  Cephalobus = c(10, NA, 15),
  Caenorhabditis = c(5, 10, NA),
  Pratylenchus = c(8, 12, 10),
  row.names = c("A", "B", "C")
)
Ecological.Indices(data = df, indices = "All", method = "Menhinick")
}
