% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PNB.R
\name{PNB}
\alias{PNB}
\title{Calculate Partial N Balance (PNB)}
\usage{
PNB(PlantNf, FertN)
}
\arguments{
\item{PlantNf}{A numeric vector of Plant N content in fertilized conditions.}

\item{FertN}{A numeric value or vector for fertilizer N input.}
}
\value{
A numeric vector of PNB values.
}
\description{
The expression of plant N content per unit of fertilizer N applied.
Formula: PNB = PlantNf / FertN
}
\examples{
PlantNf <- c(3.5, 4.0, 4.2)
FertN <- 50
PNB(PlantNf, FertN)
}
