#' Calculate NUE Yield
#' @description
#' The contribution of N supplied from the soil that is allocated to yield.
#' Formula: NUEyield = NUpE * NUtE
#' @param NUpE N Uptake Efficiency value or vector.
#' @param NUtE N Utilization Efficiency value or vector.
#' @return A numeric vector of NUEyield values.
#' @examples
#' NUpE <- c(40, 50)
#' NUtE <- c(20, 25)
#' NUEyield(NUpE, NUtE)
#' @export
NUEyield <- function(NUpE, NUtE) {
  return(NUpE * NUtE)
}