% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSR_simple.R
\name{NSR_simple}
\alias{NSR_simple}
\title{Check the native status for plant species in a political region}
\usage{
NSR_simple(
  species = NULL,
  country = NULL,
  state_province = NULL,
  county_parish = NULL,
  ...
)
}
\arguments{
\item{species}{A single species or a vector of species, with genus and specific epithet separated by a space.}

\item{country}{A single country or a vector of countries.  If a vector, length must equal length of species vector.}

\item{state_province}{A single state/province or a vector of states.  If a vector, length must equal length of species vector.}

\item{county_parish}{A single county/parish or a vector of counties.  If a vector, length must equal length of species vector.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing NSR results.
}
\description{
NSR_simple returns information on native status for species within a political region.
}
\examples{
\dontrun{

results <- NSR_simple(species = "Acer rubrum",
           country = "Canada",state_province = "Ontario")

results <- NSR_simple(species = c("Acer rubrum", "Aspen tremuloides") , 
           country = c("Canada","Canada"),state_province = c("Ontario","Ontario"))

}
}
