% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best.pair.tt.R
\name{best.pair.tt}
\alias{best.pair.tt}
\title{NPI for comparing two groups with terminated tails}
\usage{
best.pair.tt(X, Y, Lx = -Inf, Ux = Inf, Ly = -Inf, Uy = Inf)
}
\arguments{
\item{X}{numeric vector of data values}

\item{Y}{numeric vector of data values, to check if it is the best group}

\item{Lx}{numeric value, lower cut point for group X, default set to -Inf}

\item{Ux}{numeric value, upper cut point for group X, default set to Inf}

\item{Ly}{numeric value, lower cut point for group Y, default set to -Inf}

\item{Uy}{numeric value, lower cut point for group Y, default set to Inf}
}
\value{
NPI lower and upper probabilities for the event that the next future observation from group  Y is larger than the next future observation from group  X.
}
\description{
NPI lower and upper probabilities for the event that the next future observation from group  Y is larger than the next future observation from group  X.
The information available consists of precise measurements of real-valued data only within a specific range, between the cut points, where the numbers of observations to the left and to the right of this range available.
}
\examples{
data(BreakdownTimes)
data2<-split(BreakdownTimes$times, BreakdownTimes$group)
# No terminated tails, complete data
best.pair.tt(data2$X, data2$Y)
# terminated tails with Ly = 0.5, Uy = 4 and Ux = 10, but as Lx is not given then Lx=-Inf
best.pair.tt(data2$X, data2$Y, Ux = 10, Ly = 0.5, Uy = 4)

}
\references{
T.A. Maturi, P. Coolen-Schrijner and F.P.A. Coolen (2009). Nonparametric predictive pairwise comparison with terminated tails. International Journal of Approximate Reasoning, 51(1), 141-150.
}
