test_that("multi_cond_data works with multi-condition normalization",{
  data(multi_cond_data)

  res<-norma_gene(
    data=multi_cond_data,
    conditions="Diagnosis",
    replicates="Sample_id"
  )

  expect_s3_class(res, "norma_gene")
  expect_true(is.data.frame(res))
})

test_that("single_cond_data works with single-condition normalization",{
  data(single_cond_data)

  expect_warning(
    res<-norma_gene(
      data=single_cond_data,
      conditions=NULL,
      replicates="Sample_id"
    ),
    "`conditions` is NULL"
  )

  expect_s3_class(res, "norma_gene")
  expect_true(is.data.frame(res))
})
