#' Example dataset from a single condition qPCR experiment.
#'
#' A real-world qRT-PCR dataset containing raw crossing threshold (CT) values for 12 genes measured in whole blood total RNA originating a single cohort of 26 human subjects diagnosed with ischemic stroke as described in O’Connell et al. (2017).
#'
#' This dataset is suitable for demonstrating or evaluating normalization workflows for use-cases involving data from a single experimental condition.
#'
#' @format
#' A data frame structured with biological replicates in rows, replicate identifiers in a single column, and raw CT values for each of the 12 target genes in the remaining columns.
#'
#' @references
#' O'Connell, GC., Treadway, MB., Petrone, AB., Tennant, CS., Lucke-Wold, N, Chantler, PD., & Barr, TL. (2017).
#' Peripheral blood AKAP7 expression as an early marker for lymphocyte-mediated post-stroke blood brain barrier disruption.
#' \emph{Scientific Reports}, 1, 7.
#' \doi{10.1038/s41598-017-01178-5}
#'
#' @examples
#' #load example dataset
#'
#' data(single_cond_data)
#'
#' #return dataset structure
#'
#' str(single_cond_data)
#'
#' @name single_cond_data
#' @docType data
NULL
