$PROBLEM    033 with IOV SAME

$INPUT NMROW ID TIME EVID CMT AMT DV MDV

$DATA NMsimData_xgxr057_NWPRI_04.csv
IGN=@

$SUBROUTINE ADVAN4 TRANS4

$PK
LTVKA=THETA(1)
LTVV2=THETA(2)
LTVCL=THETA(3)
LTVV3=THETA(4)
LTVQ=THETA(5)

MU_1=LTVKA
KA=EXP(MU_1+ETA(1))
MU_2=LTVV2
V2=EXP(MU_2+ETA(2))
MU_3=LTVCL
CL=EXP(MU_3+ETA(3))
MU_4=LTVV3
V3=EXP(MU_4+ETA(4))
MU_5 = LTVQ
Q =EXP(MU_5+ETA(5))
S2=V2

IOVCL=ETA(6)
IF(TIME.GT.8) IOVCL=ETA(7)
CL=CL+EXP(IOVCL)

NMREP=IREP

$ERROR
  IPRED=F
  IRES=DV-IPRED

  IF (IPRED.GT.1) THEN
    W = SQRT(IPRED**2*SIGMA(1,1) + SIGMA(2,2))
  ELSE
    W=1
  ENDIF

  IWRES=IRES/W
  Y=F+F*ERR(1)+ERR(2)

;-----------------------INITIAL ESTIMATES---------------------------------
$THETA 0.782021  ; LTVKA
$THETA 4.30033   ; LTVV2
$THETA 2.44466   ; LTVCL
$THETA 5.01285   ; LTVV3
$THETA 2.12238   ; LTVQ


$OMEGA 0 FIX                          
$OMEGA BLOCK (2) 0.178294 -0.0325123 
0.318014                              
$OMEGA 0 FIX                          
$OMEGA 0 FIX                          
$OMEGA BLOCK(1)                      
0.743288                               ; IOV1.KA	; lognormal 	; 6	; IOV		; Between-occasion variability on KA 	; -
$OMEGA BLOCK(1) SAME                  ; IOV2.KA	; lognormal 	; 7	; IOV		; Between-occasion variability on KA 	; -


$SIGMA 0.0803687 
$SIGMA 0 FIX     

;; $ESTIMATION METHOD=1 POSTHOC INTER MAXEVAL=9999 NSIG=2 SIGL=9
;;            PRINT=10 NOABORT MSFO=xgxr057.msf





$SIMULATION ONLYSIM (1088137688) SUBPROBLEMS=2 

$TABLE NMROW PRED IPRED NMREP NOPRINT NOAPPEND ONEHEADERALL NOTITLE FORMAT=s1PE16.9 FILE=xgxr057_NWPRI_04.tab

