% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_nmar_engine_methods.R
\name{nmar_engine_helpers}
\alias{nmar_engine_helpers}
\title{S3 helpers for NMAR engine objects}
\description{
Lightweight, user-facing methods for engine configuration objects
(class `nmar_engine`). These improve discoverability and provide a
consistent print surface across engines while keeping the objects as
simple lists internally.
}
\section{Design}{

- `engine_name()` returns a canonical identifier used across the
  package (e.g., in `nmar_result$meta$engine_name`).
- `print.nmar_engine()` provides a concise, readable summary of the
  engine configuration; engine-specific classes reuse the parent
  method unless they need to override it.
- `engine_config()` returns the underlying configuration as a named
  list for programmatic inspection.
}

\keyword{engine_view}
