% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines_el_impl_equations.R
\name{el_build_equation_system}
\alias{el_build_equation_system}
\title{Empirical likelihood estimating equations}
\usage{
el_build_equation_system(
  family,
  missingness_model_matrix,
  auxiliary_matrix,
  respondent_weights,
  N_pop,
  n_resp_weighted,
  mu_x_scaled
)
}
\description{
Empirical likelihood estimating equations
}
\details{
Returns a function that evaluates the stacked EL system for
  \eqn{\theta = (\beta, z, \lambda_x)} with \eqn{z = \operatorname{logit}(W)}.
  Blocks correspond to: (i) missingness (response) model score equations in \eqn{\beta},
  (ii) the response-rate equation in \eqn{W}, and (iii) auxiliary moment
  constraints in \eqn{\lambda_x}. When no auxiliaries are present the last
  block is omitted. The system matches Qin, Leung, and Shao (2002, Eqs. 7-10)
  with empirical masses \eqn{m_i = d_i/D_i(\theta)}, \eqn{D_i} as in the paper.
  We cap \eqn{\eta}, clip \eqn{w_i} in ratios, and guard \eqn{D_i} away from zero to
  ensure numerical stability; these safeguards are applied consistently in
  equations, Jacobian, and post-solution weights.

  \strong{Guarding policy (must remain consistent across equations/Jacobian/post):}
  \itemize{
    \item Cap \eqn{\eta}:
      \code{eta <- pmax(pmin(eta, get_eta_cap()), -get_eta_cap())}.
    \item Compute \code{w <- family$linkinv(eta)} and clip to
      \code{[1e-12, 1 - 1e-12]} when used in ratios.
    \item Denominator floor:
      \code{Di <- pmax(Di_raw, nmar_get_el_denom_floor())}. In the Jacobian,
      terms that depend on \code{d(1/Di)/d(.)} are multiplied by
      \code{active = 1(Di_raw > floor)} to match the clamped equations.
  }

  The score with respect to the linear predictor uses the Bernoulli form
  \eqn{s_{\eta,i}(\beta) = \partial \log w_i / \partial \eta_i = \mu.\eta(\eta_i)/w_i},
  which is valid for both logit and probit links when \eqn{w_i} is clipped.
}
\references{
Qin, J., Leung, D., and Shao, J. (2002). Estimation with survey data under
nonignorable nonresponse or informative sampling. Journal of the American Statistical Association, 97(457), 193-200.
}
\keyword{internal}
