% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NGLVieweR.R
\name{stageParameters}
\alias{stageParameters}
\title{Set stage parameters}
\usage{
stageParameters(NGLVieweR, ...)
}
\arguments{
\item{NGLVieweR}{A NGLVieweR object.}

\item{...}{Options controlling the stage. Most common options are
\code{backgroundColor}, \code{rotateSpeed}, \code{zoomSpeed},
\code{hoverTimeout} and \code{lightIntensity}. For a full list of options,
see the "stageParameters" method in the official
\href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}
}
\value{
Returns list of stage parameters to \code{NGLVieweR}
\code{htmlwidgets} object.
}
\description{
Set stage parameters.
}
\examples{
NGLVieweR("7CID") \%>\%
 stageParameters(backgroundColor = "white", zoomSpeed = 1) \%>\%
 addRepresentation("cartoon", param = list(name = "cartoon", colorScheme="residueindex"))

if (interactive()) {
  library(shiny)
  ui <- fluidPage(NGLVieweROutput("structure"))
  server <- function(input, output) {
    output$structure <- renderNGLVieweR({
      NGLVieweR("7CID") \%>\%
        stageParameters(backgroundColor = "white", zoomSpeed = 1) \%>\%
        addRepresentation("cartoon",
          param = list(name = "cartoon", colorScheme = "residueindex")
        )
    })
  }
  shinyApp(ui, server)
}

}
\seealso{
\itemize{
\item \code{\link[=updateStage]{updateStage()}}
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "basic".
}
}
