% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NGLVieweR.R
\name{setRotation}
\alias{setRotation}
\title{Rotate View}
\usage{
setRotation(NGLVieweR, x = 0, y = 0, z = 0, degrees = TRUE)
}
\arguments{
\item{NGLVieweR}{A NGLVieweR object.}

\item{x}{Rotation angle around the x-axis. Default is 0.}

\item{y}{Rotation angle around the y-axis. Default is 0.}

\item{z}{Rotation angle around the z-axis. Default is 0.}

\item{degrees}{A logical value. If TRUE (default), the input angles are
assumed to be in degrees and will be converted to radians. If FALSE, the
angles are assumed to be in radians.}
}
\value{
NGLVieweR object with updated rotateView parameters.
}
\description{
Set rotation for the representation
}
\examples{
NGLVieweR("7CID") \%>\%
stageParameters(backgroundColor = "white") \%>\%
addRepresentation("cartoon", param=list(name="cartoon", colorValue="red")) \%>\%
addRepresentation("ball+stick", param=list(name="ball+stick",
colorValue="yellow",
colorScheme="element",
sele="200")) \%>\%
setRotation(30, 45, 60, degrees = TRUE)
}
\seealso{
\itemize{
\item \code{\link[=setScale]{setScale()}}
\item \code{\link[=zoomMove]{zoomMove()}}
\item \code{\link[=setPosition]{setPosition()}}
}

Other transformations: 
\code{\link{setPosition}()},
\code{\link{setScale}()},
\code{\link{zoomMove}()}
}
\concept{transformations}
