% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{nearest.to}
\alias{nearest.to}
\title{Select the nearest point in an array to a given value}
\usage{
nearest.to(array, point, dispute.method = c("first", "last", "random"))
}
\arguments{
\item{array}{a numeric vector or POSIXct vector of date-times.}

\item{point}{the value that you want to find the nearest point to.}

\item{dispute.method}{when there are equidistant values to 'point' in
array, choose either the first, last, or a random select, based
on the original order in 'array.}
}
\value{
index value of the nearest point in 'array'.
}
\description{
Similar to the base function match() but allows for data where you
won't find an exact match. Selects the nearest value from 'array' to the
value 'point'. Sometimes there are multiple points with equal distance
in which case choose from 3 possible 'dispute.method's for choosing
which of the equidistant array values to index.
returns the index of 'array' to which 'point' is nearest.
}
\examples{
myArray <- 1:100
nearest.to(myArray, 7.7)
nearest.to(myArray, 50.5)
nearest.to(myArray, 50.5, dispute.method="last")
}
\author{
Nicholas Cooper \email{njcooper@gmx.co.uk}
}
