% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam_cont.R
\name{gam_cont}
\alias{gam_cont}
\title{Generalized additive model analysis for continuous data}
\usage{
gam_cont(
  data,
  arm,
  alpha = 0.025,
  ci = FALSE,
  smoothing_basis = "tp",
  basis_dim = -1,
  gam_method = "GCV.Cp",
  check = TRUE,
  ...
)
}
\arguments{
\item{data}{Data frame with trial data, e.g. result from the \code{datasim_cont()} function. Must contain columns named 'treatment', 'response', 'period' and 'j'.}

\item{arm}{Integer. Index of the treatment arm under study to perform inference on (vector of length 1). This arm is compared to the control group.}

\item{alpha}{Double. Significance level (one-sided). Default=0.025.}

\item{ci}{Logical. Indicates whether confidence intervals should be computed. Default=FALSE.}

\item{smoothing_basis}{String indicating the (penalized) smoothing basis to use. Default="tp" for thin plate regression spline. Available strings are 'tp', 'ts', 'ds', 'cr', 'cs', 'cc', 'sos', 'ps', 'cp', 're', 'mrf', 'gp', and 'so'. For more information see https://stat.ethz.ch/R-manual/R-devel/library/mgcv/html/smooth.terms.html.}

\item{basis_dim}{Integer. The dimension of the basis used to represent the smooth term. The default depends on the number of variables that the smooth is a function of. Default=-1. For more information see the description of the parameter 'k' in https://stat.ethz.ch/R-manual/R-devel/library/mgcv/html/s.html.}

\item{gam_method}{String indicating the smoothing parameter estimation method. Default="GCV.Cp". Available strings are 'GCV.Cp', 'GACV.Cp', 'REML', 'P-REML', 'ML', and 'P-ML'. For more information see the description of the parameter 'method' in https://stat.ethz.ch/R-manual/R-devel/library/mgcv/html/gam.html.}

\item{check}{Logical. Indicates whether the input parameters should be checked by the function. Default=TRUE, unless the function is called by a simulation function, where the default is FALSE.}

\item{...}{Further arguments passed by wrapper functions when running simulations.}
}
\value{
List containing the following elements regarding the results of comparing \code{arm} to control:
\itemize{
\item \code{p-val} - p-value (one-sided)
\item \code{treat_effect} - estimated treatment effect in terms of the difference in means
\item \code{lower_ci} - lower limit of the (1-2*\code{alpha})*100\% confidence interval
\item \code{upper_ci} - upper limit of the (1-2*\code{alpha})*100\% confidence interval
\item \code{reject_h0} - indicator of whether the null hypothesis was rejected or not (\code{p_val} < \code{alpha})
\item \code{model} - fitted model
}
}
\description{
This function performs analysis using a generalized additive model taking into account all trial data until the arm under study leaves the trial and smoothing over the patient entry index.
}
\examples{

trial_data <- datasim_cont(num_arms = 3, n_arm = 100, d = c(0, 100, 250),
theta = rep(0.25, 3), lambda = rep(0.15, 4), sigma = 1, trend = "linear")

gam_cont(data = trial_data, arm = 3, ci = TRUE)

}
\author{
Pavla Krotka
}
