% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSADF.R
\name{gsadf}
\alias{gsadf}
\title{Critical values for generalized sup ADF statistic sequence.}
\usage{
gsadf(m, t, adflag = 0, mflag = 1, swindow0 = floor(r0 * t))
}
\arguments{
\item{m}{Number of Monte Carlo Simulations. Default equals 2000. Must be bigger than 2.}

\item{t}{Sample size. Default equals 100. Must be bigger than 2.}

\item{adflag}{Number of lags to be included in the ADF Test. Default equals 0.}

\item{mflag}{1 for ADF with constant and whithout trend, 2 for ADF with constant and trend and 3 for ADF without constant and trend.}

\item{swindow0}{Minimum window size.}
}
\description{
Calculate critical value sequences for the generalized sup ADF statistic sequence
 using Monte Carlo simulations for a sample generated from a Normal distribution.
}
\examples{
foo <- gsadf(m = 20, t = 50)
quant <- rep(foo$quantiles[2], 100)
plot(quant, type = 'l')
}
\references{
Phillips, P.C. & Shi, S. & Yu, J. (2015a). "Testing for Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the S&P 500". \emph{SSRN Electronic Journal}.
}
\keyword{AugmentedDickey-FullerTest}
\keyword{GSADFSequence}
\keyword{MonteCarlo.}
