% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSR_hodgson.R
\name{CSR_hodgson}
\alias{CSR_hodgson}
\title{Classify Plant Strategies using Hodgson et al. (1999) CSR Method}
\usage{
CSR_hodgson(data)
}
\arguments{
\item{data}{A \code{data.frame} containing the following columns:
\describe{
\item{growth_form}{Character vector: plant growth form, "g" for graminoid, "n" for non-graminoid.}
\item{CH}{Numeric: Canopy height (mm).}
\item{LDMC}{Numeric: Leaf dry matter content (percent).}
\item{FP}{Numeric: Flowering period (# of months).}
\item{LS}{Numeric: Lateral spread (six-point classification).}
\item{LDW}{Numeric: Leaf dry weight (mg).}
\item{SLA}{Numeric: Specific leaf area (mm2/mg).}
\item{FS}{Numeric: Flowering start (month).}
}}
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item \code{growth_form, CH, LDMC, FP, LS, LDW, SLA, FS} — copied from input;
\item \code{C, S, R} — calculated CSR percentages;
\item \code{type} — assigned CSR type label (e.g., "C", "CSR", "S/CSR").
}
}
\description{
This function calculates C, S, and R scores as percentages based on input
plant trait data, following the approach of Hodgson et al. (1999) and its
application in Caccianiga et al. (2006). Input is a dataframe with specific
trait columns, and the output is a new dataframe containing calculated
CSR coordinates, percentages, and assigned CSR type.
}
\details{
Implements the Hodgson et al. (1999) method for allocating plant species
into the CSR (Competitor–Stress-tolerator–Ruderal) triangle based on plant
functional traits. Also assigns each species to the nearest CSR type.

This implementation:
\itemize{
\item Uses different equations for graminoids and non-graminoids to compute raw CSR dimensions.
\item Scales results to coordinate space \eqn{[-2.5, 2.5]}, then shifts to positive and converts to percentages.
\item Assigns the nearest CSR type based on standard reference CSR percentages from Hodgson's scheme.
}
}
\note{
Input data must not contain \code{NA} values in required columns. If such values
are present, the function will stop with an error.
}
\examples{
# Example trait dataset
traits <- data.frame(
  growth_form = c("g", "g", "n", "g", "n"),
  CH = c(45.3, 169.7, 13.7, 132.7, 76.0),
  LDMC = c(33.0, 37.9, 25.9, 28.0, 15.7),
  FP = c(2, 2, 2, 1, 2),
  LS = c(3, 5, 4, 2, 5),
  LDW = c(1.9, 9.9, 2.3, 7.5, 40.2),
  SLA = c(19.0, 20.4, 15.2, 22.6, 21.8),
  FS = c(5, 5, 4, 5, 5)
)

# Run CSR classification
result <- CSR_hodgson(traits)
print(result)

# Plot CSR positions
CSR_plot(data = result)

}
\references{
\enumerate{
\item Hodgson, J.G., Wilson, P.J., Hunt, R., Grime, J.P. & Thompson, K. (1999).
Allocating CSR plant functional types: a soft approach to a hard problem. Oikos, 85, 282–294.
\item Caccianiga, M., Luzzaro, A., Pierce, S., Ceriani, R.M. & Cerabolini, B. (2006).
The functional basis of a primary succession resolved by CSR classification. Oikos, 112, 10–20.
}
}
