% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{Partitions}
\alias{Partitions}
\title{General Partition Function}
\usage{
Partitions(Type, ...)
}
\arguments{
\item{Type}{A character string specifying the type of partion to compute. Choose from "2Perm", "Diagram", "Indecomp", "Pairs".}

\item{...}{Additional arguments passed to the specific partition function:
\describe{
  \item{{For "2Perm", "Diagram" and "Indecomp":}}{
    \itemize{
      \item{\code{L}}: A partition matrix.
    }
  }
  \item{{For "Pairs":}}{
    \itemize{
      \item{\code{N}}: An integer specifying the number of elements to be partitioned.
    }
  }
}}
}
\value{
Depending on the commutator type:
\describe{
  \item{2Perm}{A vector with the elements 1 to N permuted according to L.}
  \item{Diagram}{The list of partition matrices indecomposable with respect to L, representing diagrams without loops.}
  \item{Indecomp}{A list of partition matrices indecomposable with respect to L and a vector indicating the number of indecomposable partitions by sizes.}
  \item{Pairs}{The list of partition matrices with blocks containing two elements. The list is empty if N is odd.}
}
}
\description{
A unified function to compute different types of partitions. Depending on the partition type specified, it calls the appropriate function: Partition_2Perm, Partition_DiagramsClosedNoLoops, Partition_Indecomposable, or Partition_Pairs.
}
\examples{
# Example for 2Perm
PA <- PartitionTypeAll(4)
Partitions("2Perm", L = PA$Part.class[[3]])

# Example for Diagram
L <- matrix(c(1,1,0,0,0,0,1,1),2,4,byrow=TRUE)
Partitions("Diagram", L = L)

# Example for Indecomp
L <- matrix(c(1,1,0,0,0,0,1,1),2,4,byrow=TRUE)
Partitions("Indecomp", L = L)

# Example for Pairs
Partitions("Pairs", N = 4)
}
\seealso{
Other Partitions: 
\code{\link{PartitionTypeAll}()},
\code{\link{PermutationInv}()}
}
\concept{Partitions}
