% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multigreyfit.R
\name{multigreyfit}
\alias{multigreyfit}
\title{Fit the GM (1, 1) model for multivariate time series data}
\usage{
multigreyfit(data)
}
\arguments{
\item{data}{Input multivariate time series data.}
}
\value{
A list with the following components:
\item{a}{Control variable, i.e., parameter of fitted GM (1, 1) model for each of the time series variables.}
\item{b}{Developing coefficient, i.e., parameter of fitted GM (1, 1) model for each of the time series variables.}
\item{mse}{Mean Squared Error (MSE) for each time series variable.}
\item{rmse}{Root Mean Square Error (RMSE) of fitted GM (1, 1) model for each of the time series variables}
\item{mape}{Relative Mean Absolute Percentage Error (MAPE) of fitted GM (1, 1) model for each of the time series variables}
\item{mae}{Mean Absolute Error (MAE) of fitted GM (1, 1) model for each of the time series variables}
}
\description{
The multigreyfit function fits the GM (1,1) model for multivariate time series data and computes its model parameters as well as different model evaluation criteria.
}
\details{
This function returns the parameters of the fitted grey model, i.e., a and b which are known as control variable
 and developing coefficient respectively for each of the of the variables in the multivariate timeseries data. This function
 also returns the mean square error (MSE), mean absolute error (MAE), root mean square error (RMSE) and relative mean absolute percentage error (MAPE)
  values of the fitted GM (1, 1) model for each of the variables in the multivariate time series data.
}
\examples{
# Example data
xt <- c(640, 684, 713, 745, 809, 811, 883, 893, 904, 935, 1044, 1069)
yt <- c(50, 64, 93, 113, 131, 152, 164, 201, 224, 268, 286, 290)
zt  <- c(550,504,493,413,431,352,364,301,294,268,286,230)
data <- cbind(xt, yt, zt)

# Apply the multigreyfit function
multigreyfit(data)
}
\references{
Akay, D. and Atak, M. (2007). Grey prediction with rolling mechanism for electricity demand forecasting of Turkey.
\emph{Energy}, 32(9), 1670-1675.<DOI:10.1016/j.energy.2006.11.014>

Deng, J. (1989). Introduction to grey system theory. \emph{The Journal of Grey System}, 1(1), 1-24.

Hsu, L.C. and Wang, C.H. (2007). Forecasting the output of integrated circuit industry using a grey model improved by
Bayesian analysis. \emph{Technological Forecasting and Social Change}, 74(6), 843-853.<DOI:10.1016/j.techfore.2006.02.005>
}
