% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumOutputs.R
\name{ComputeGFEVDs}
\alias{ComputeGFEVDs}
\title{Compute GFEVDs for all models}
\usage{
ComputeGFEVDs(
  SIGMA,
  K1Z,
  G0,
  BLoad,
  FactorLabels,
  FacDim,
  MatLength,
  GFEVDhoriz,
  YieldsLabel,
  ModelType,
  Economy,
  PI = NULL,
  Mode = FALSE
)
}
\arguments{
\item{SIGMA}{Variance-covariance matrix}

\item{K1Z}{Loading As}

\item{G0}{contemporaneous terms}

\item{BLoad}{Loading Bs}

\item{FactorLabels}{List containing the label of factors}

\item{FacDim}{Dimension of the P-dynamics}

\item{MatLength}{Length of the maturity vector}

\item{GFEVDhoriz}{Horizon of the analysis}

\item{YieldsLabel}{Label of bond yields}

\item{ModelType}{Desired model type}

\item{Economy}{specific economy under study}

\item{PI}{matrix PI for JLL-based models}

\item{Mode}{allows for the orthogonalized version in the case of JLL-based models}
}
\description{
Compute GFEVDs for all models
}
\references{
\itemize{
\item This function is a modified and extended version of the "fevd" function from
Smith, L.V. and A. Galesi (2014). GVAR Toolbox 2.0, available at https://sites.google.com/site/gvarmodelling/gvar-toolbox.

\item Pesaran and Shin, 1998. "Generalized impulse response analysis in linear multivariate models" (Economics Letters)
}
}
\keyword{internal}
