% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{extract}
\alias{extract}
\alias{extract.mplus.model}
\alias{extract.mplusObject}
\alias{extract,mplus.model-method}
\alias{extract,mplusObject-method}
\title{Extract function to make Mplus output work with the \pkg{texreg} package}
\usage{
extract.mplus.model(
  model,
  summaries = "none",
  cis = FALSE,
  escape.latex = FALSE,
  ...
)

extract.mplusObject(model, summaries = "none", cis = FALSE, ...)

\S4method{extract}{mplus.model}(model, summaries = "none", cis = FALSE, escape.latex = FALSE, ...)

\S4method{extract}{mplusObject}(model, summaries = "none", cis = FALSE, ...)
}
\arguments{
\item{model}{An Mplus model object.  This typically comes either from
\code{\link{readModels}} directly, or indirectly via
\code{\link{mplusModeler}}.  The results will have different classes,
but extract methods are defined for both.}

\item{summaries}{A character vector which summaries to include.
Defaults to \dQuote{none}.}

\item{cis}{A logical whether to extract confidence intervals.}

\item{escape.latex}{A logical value whether to escape dollar signs in
coefficient names for LaTeX.  Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link{coef.mplus.model}}.}
}
\value{
A \code{texreg} object, or for multiple group models,
a list of \code{texreg} objects.
}
\description{
This is a method for extracting output in a format
suitable for the \pkg{texreg} package.  Uses \code{coef} for most the work.
}
\examples{
\dontrun{
# simple example of a model using builtin data
# demonstrates use
test <- mplusObject(
  TITLE = "test the MplusAutomation Package;",
  MODEL = "
    mpg ON wt hp;
    wt WITH hp;",
  OUTPUT = "STANDARDIZED;",
  usevariables = c("mpg", "wt", "hp"),
  rdata = mtcars)

res <- mplusModeler(test, "mtcars.dat", modelout = "model1.inp", run = 1L)

extract(res$results)
# there is also a method for mplusObject class
extract(res)

# load the texreg package
# to use pretty printing via screenreg
# uncomment to run these examples
# library(texreg)
# screenreg(res)
# screenreg(res, type = 'stdyx')

# screenreg(res, type = 'un', params = 'regression',
#   single.row=TRUE)
# screenreg(res, type = 'un', params = 'regression', summaries = 'CFI',
#   single.row=TRUE)

# remove files
unlink("mtcars.dat")
unlink("model1.inp")
unlink("model1.out")
unlink("Mplus Run Models.log")
}
}
\seealso{
\code{\link{readModels}}

Other Mplus-Formatting: 
\code{\link{coef.mplus.model}()},
\code{\link{confint.mplus.model}()},
\code{\link{print.MplusRstructure}()},
\code{\link{summary.mplusObject}()}
}
\author{
Joshua F. Wiley \href{mailto:jwiley.psych@gmail.com}{jwiley.psych@gmail.com}
}
\concept{Mplus-Formatting}
\keyword{interface}
