% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.regions_pco.R
\name{plot.regions_pco}
\alias{plot.regions_pco}
\title{Plot PCO axes}
\usage{
\method{plot}{regions_pco}(x, pco_y = 1, pco_x = NULL, ...)
}
\arguments{
\item{x}{a \code{regions_pco} object; the output of a call to \code{\link[=svdPCO]{svdPCO()}}.}

\item{pco_y, pco_x}{number; PCO score indices for the y- and x-axes, respectively. \code{pco_x} can be \code{NULL}.}

\item{...}{arguments passed to \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}} when \code{pco_x} is not \code{NULL}. If \code{scores} is supplied as an argument, it will replace \code{pco_y} if unspecified.}
}
\value{
A \code{ggplot} object.
}
\description{
\code{plot()} visualizes the relationship between a PCO axis and the vertebra or between pairs of PCO axes.
}
\details{
When \code{pco_x} is \code{NULL} (the default), \code{plot()} will display a scatterplot of the PCO axis identified by \code{pco_y} and vertebra position using \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}. This plot is similar to that generated by \code{\link[=plotsegreg]{plotsegreg()}}. Otherwise, \code{plot()} uses \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}} to identify vertebrae positions in the space corresponding to the requested PCOs.
}
\examples{
data("alligator")

alligator_data <- process_measurements(alligator,
                                       pos = "Vertebra")

# Compute PCOs
alligator_PCO <- svdPCO(alligator_data,
                        metric = "gower")

alligator_PCO

# Plot PCOs against vertebra index
plot(alligator_PCO, pco_y = 1:2)

# Plot PCOs against each other
plot(alligator_PCO, pco_y = 1, pco_x = 2)
}
\seealso{
\code{\link[=svdPCO]{svdPCO()}} for generating the PCO scores. \code{\link[=plot.regions_sim]{plot.regions_sim()}} for plotting PCO scores against vertebra position for simulated PCOs. \code{\link[=plotsegreg]{plotsegreg()}} for plotting PCO scores against vertebra position after selecting breakpoints for a segmented regression.
}
