% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.snapshot.single.R
\name{get.snapshot.single}
\alias{get.snapshot.single}
\title{Derive snapshot of selected individuals}
\usage{
get.snapshot.single(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  id = NULL,
  phenotype.data = FALSE,
  gain.data = FALSE,
  digits = 3,
  time.diff = 1,
  min.time = -Inf,
  max.time = Inf,
  use.all.copy = TRUE,
  verbose = TRUE,
  time.points = NULL,
  include.culled = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{id}{Individual IDs to search/collect in the database}

\item{phenotype.data}{Set to TRUE to include information of number of phenotypes generated}

\item{gain.data}{Set to TRUE to add information on changes in genetic level between cohorts (default: FALSE)}

\item{digits}{Number of digits provided for the gain.data output (default: 3)}

\item{time.diff}{Set to a target time interval to receive information between transitions to other cohorts (default: NA)}

\item{min.time}{Earliest time point relevant for output results (default: -Inf)}

\item{max.time}{Latest time point relevant for output results (default: Inf)}

\item{use.all.copy}{Set to TRUE to extract phenotyping}

\item{verbose}{Set to FALSE to not display any prints (default: TRUE)}

\item{time.points}{Use this parameter to manual provide a vector of time points on results should be generated for (default: NULL)}

\item{include.culled}{Set to TRUE to also include culled individuals in the statistics provided}
}
\value{
Snapshot Matrix
}
\description{
Function to derive snapshot of genotyping/phenotyping state of selected individuals
}
\examples{
data(ex_pop)
get.snapshot.single(ex_pop, cohorts = "Cohort_2_M")
}
