% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_best_split.R
\name{find_best_split}
\alias{find_best_split}
\title{find_best_split}
\usage{
find_best_split(locs, times, movement, from, to)
}
\arguments{
\item{locs}{character, A vector of the locations of occurrences.}

\item{times}{POSIXct, A vector of the occurrences corresponding timestamps.}

\item{movement}{A lubridate interval for which the best split is to be found.}

\item{from}{character,  the name of the location the \code{movement} ends at. Must match an element in \code{locs}.}

\item{to}{character, the name of the location the \code{movement} ends at. Must match an element in \code{locs}.}
}
\value{
A tibble of 2 fields: \itemize{
\item{\strong{split_time}, a lubridate date time which indicates the time of the optimal split found}
\item{\strong{split_correctness}, a numeric date time which indicates the split's ratio of the wrongly assigned days to the correctly assigned days}
}
}
\description{
Find the optimal point in time to split a migration interval
}
\details{
The function checks which occurrences by \code{locs} and \code{times} fall within the interval given by \code{movement}.
It then tries to find the optimal point in time to split the interval, using the following two criteria:\itemize{
\item{The point which minimizes the number of misclassified \strong{days}, i.e., the number of days when the migrant
appears at \code{to} before the migration date and days when the migrant appears at
\code{from} after the migration date.}
\item{In cases where multiple days yield the same number of misclassifications, we select the last timestamp as the migration date}
}
}
\references{
Chi, Guanghua, Fengyang Lin, Guangqing Chi, and Joshua Blumenstock. 2020. “A General Approach to Detecting Migration Events in Digital Trace Data.” Edited by Song Gao. PLOS ONE 15 (10): e0239408. https://doi.org/10.1371/journal.pone.0239408.
}
\author{
Johannes Mast \email{Johannes.Mast@dlr.de}, based on the algorithm by Guanghua Chi \email{guanghua@berkeley.edu}
}
