% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqrt_mse.R
\name{sqrt_mse}
\alias{sqrt_mse}
\title{Plot the square root of the mean squared errors}
\usage{
sqrt_mse(object, rarea = FALSE)
}
\arguments{
\item{object}{list returned by \link{measure_compare} function.}

\item{rarea}{if \code{TRUE}, draw the plot with shading areas between
the confidence bands.}
}
\description{
This function draws the "sqrt(MSE) plot", which is used to compare the precision of
the two measurement methods without recalibrating the new method.
It is obtained by graphing the square root mean squared errors of \code{y1} (new method) and \code{y2} (reference
method) versus the BLUP of the latent trait, \code{x}, along with their 95\%
simultaneous confidence bands.
}
\examples{
\donttest{
### Load the data
data(data1)
### Analysis
measure_model <- measure_compare(data1, nb_simul=100)
### Plot the square root mean squared errors
sqrt_mse(measure_model)}
}
