% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BA.plot.r, R/pbreg.R, R/plot.Meth.R,
%   R/plot.VarComp.R
\name{BA.plot}
\alias{BA.plot}
\alias{plot.PBreg}
\alias{plot.Meth}
\alias{plot.VarComp}
\title{Bland-Altman plot of differences versus averages.}
\usage{
BA.plot(
  y1,
  y2,
  meth.names = NULL,
  wh.comp = 1:2,
  pl.type = "BA",
  dif.type = "const",
  sd.type = "const",
  model = if (inherits(y1, "Meth") & has.repl(y1)) "exch" else NULL,
  eqax = FALSE,
  axlim = if (is.data.frame(y1)) range(y1$y) else range(c(y1, y2)),
  diflim = NULL,
  grid = TRUE,
  N.grid = 10,
  col.grid = grey(0.9),
  points = TRUE,
  col.points = "black",
  cex.points = 1,
  pch.points = 16,
  lwd = c(3, 1, 1),
  col.lines = "blue",
  repl.conn = FALSE,
  col.conn = "gray",
  lwd.conn = 1,
  xlab = NULL,
  ylab = NULL,
  eqn = FALSE,
  col.eqn = col.lines,
  font.eqn = 2,
  digits = 2,
  Transform = if (mult) "log" else NULL,
  mult = FALSE,
  alpha = NULL,
  ...
)

\method{plot}{PBreg}(
  x,
  pch = 21,
  bg = "#2200aa33",
  xlim = c(0, max(x$model)),
  ylim = c(0, max(x$model)),
  xlab = x$meths[1],
  ylab = x$meths[2],
  subtype = 1,
  colors = list(CI = "#ccaaff50", fit = "blue", ref = "#99999955", bars = "gray", dens =
    "#8866aaa0", ref2 = c("#1222bb99", "#bb221299")),
  ...
)

\method{plot}{Meth}(
  x,
  which = NULL,
  col.LoA = "blue",
  col.pt = "black",
  cex.name = 2,
  var.range,
  diff.range,
  var.names = FALSE,
  pch = 16,
  cex = 0.7,
  Transform,
  ...
)

\method{plot}{VarComp}(
  x,
  which,
  lwd.line = rep(2, 4),
  col.line = c("red", "green", "blue", "black"),
  lty.line = rep(1, 4),
  grid = TRUE,
  col.grid = gray(0.8),
  rug = TRUE,
  probs = c(5, 50, 95),
  tot.var = FALSE,
  same.ax = TRUE,
  meth.names = TRUE,
  VC.names = "first",
  ...
)
}
\arguments{
\item{y1}{Numerical vector of measurements by 1st method. Can also be a
\code{\link{Meth}} or a \code{\link{MethComp}} object, see details.}

\item{y2}{Numerical vector of measurements by 2nd method. Must of same
length as \code{x}. Ignored if a \code{\link{Meth}} or a
\code{\link{MethComp}} objects is given for \code{y1}.}

\item{meth.names}{Should the names of the methods be put on the plots?}

\item{wh.comp}{Which methods should be compared. Either numerical or
character.}

\item{pl.type}{What type of plot should be made, \code{"BA"} for differences
versus averages, \code{"conv"} for method 1 versus method 2.}

\item{dif.type}{How should difference depend on the averages. \code{"const"}
or \code{"lin"}.}

\item{sd.type}{How should the standard deviation depend on the averages.
\code{"const"} or \code{"lin"}.}

\item{model}{Should a variance component model be used to compute the limits
of agreement? If \code{NULL} a simple analysis is made; other possibilities
are \code{"exch"} or \code{"linked"} for exchangeable or linked replicates.}

\item{eqax}{Should the axes be identical? If a Bland-Altman plot is drawn,
the axis for the differences will have the same extent as the axis for the
averages, but centered on 0 (see \code{diflim}).}

\item{axlim}{The limits of the axes.}

\item{diflim}{The limits of the difference axis.}

\item{grid}{Logical. Should a vertical grid be set up? If numeric it is set
up at the values specified. If \code{same.ax}, the range of the grid is
taken to be the extent of the x-axis for all plots.}

\item{N.grid}{How many grid-lines should be drawn.}

\item{col.grid}{The color of the grid.}

\item{points}{Logical. Should the observed points be drawn?}

\item{col.points}{What color should they have?}

\item{cex.points}{How large should they be?}

\item{pch.points}{What plot character for the points}

\item{lwd}{Numerical vector of 3, giving the width of the conversion line
(mean difference) and the limits of agreement.}

\item{col.lines}{What color should the lines have.}

\item{repl.conn}{Should replicate measurements be connected (within items)?}

\item{col.conn}{Color of connecting lines.}

\item{lwd.conn}{Width of connecting lines.}

\item{xlab}{Label on the x-axis.}

\item{ylab}{Label on the y-axis.}

\item{eqn}{Logical. Should the equations linking the methods be shown on the
plot? If a Bland-Altman plot is made, both the equations linking the methods
and the equation for the differences versus the averages are shown.}

\item{col.eqn}{Color for equations}

\item{font.eqn}{Font for equations}

\item{digits}{How many digits after the decimal point should be used when
showing the equations.}

\item{Transform}{Transformation used to the measurements prior to plotting.
Function or character, see \code{\link{choose.trans}} for possible values.}

\item{mult}{Logical. If TRUE, ratios of measurement instead of differences
will be plotted in the Bland-Altman plot on a logarithmic axis, and limits
of agreement will be given on this scale?  This gives the same analysis as
using \code{Transform="log"}, but a different plot. Using another
transformation than the log is accommodated, but no LoA is shown on the
axis.}

\item{alpha}{1 minus the confidence level. If \code{NULL} a multiplier of 2
is used for constructing prediction limits, otherwise a t-quantile with d.f.
equal th number of items minus 1.}

\item{...}{Parameters passed on the \code{\link{density}} furnction that
does the smoothing of the posterior samples.}

\item{x}{A \code{MCmcmc} object.}

\item{pch}{Plot character for points.}

\item{bg}{Background colour for the plotting character.}

\item{xlim}{Limits for the x-axis.}

\item{ylim}{Limits for the y-axis.}

\item{subtype}{a numeric value or vector, that selects the desired plot
subtype.  Subtype \bold{1} is an x-y plot of raw data with regression line
and confidence boundaries for the fit as a shaded area.  This is the
default.  Subtype \bold{2} is a ranked residuals plot.  Subtype \bold{3} is
the "Cusum" plot useful for assessing linearity of the fit. Plot subtypes 1
through 3 are standard plots from the 1983 paper by Passing and Bablok - see
the reference.  Plot subtype \bold{4} is a histogram (with overlaid density
line) of the individual slopes.  The range of this plot is limited to 5 x
IQR for better visibility.}

\item{colors}{A list of 6 elements allowing customization of colors of
various plot elements. For plot subtype 1: "CI" is the color of the shaded
confidence interval area; and "fit" is the color of fit line. For plot
subtypes 2 & 3: "ref" is the color of the horizontal reference line. For
plot subtype 4: "bars" is the bar background color, "dens" is the color of
the density line, and "ref2" is a vector of two colors for lines indicating
the median and confidence limits.}

\item{which}{For which of the compared methods should the plot be made?}

\item{col.LoA}{What color should be used for the limits of agreement.}

\item{col.pt}{What color should be used for the points.}

\item{cex.name}{Character expansion factor for plotting method names}

\item{var.range}{The range of both axes in the scatter plot and the x-axis
in the Bland-Altman plot be?}

\item{diff.range}{The range of yaxis in the Bland-Altman plot. Defaults to a
range as the x-axis, but centered around 0.}

\item{var.names}{If logical: should the individual panels be labelled with
the variable names?. If character, then the values of the character will be
used to label the methods.}

\item{cex}{Plot charcter expansion for points.}

\item{lwd.line}{Line width for drawing the density.}

\item{col.line}{Color for drawing the densities.}

\item{lty.line}{Line type for drawing the densities.}

\item{rug}{Should a small rug at the bottom show posterior quantiles?}

\item{probs}{Numeric vector with numbers in the range from 0 to 100,
indicating the posterior percentiles to be shown in the rug.}

\item{tot.var}{Should the posterior of the total variance also be shown?}

\item{same.ax}{Should the same axes be used for all methods?}

\item{VC.names}{Should the names of the variance components be put on the
first plot (\code{"first"}), the last (\code{"last"}), all (\code{"all"}) or
none (\code{"none"}). Only the first letter is needed.}
}
\value{
An object of class \code{\link{MethComp}} and either \code{DA.reg}
(if \code{model=NULL}) or \code{BA.est} (if \code{model} is character).

A plot as a side effect

A list with one element for each method.  Each element of this is a
list of densities, i.e. of objects of class \code{density}, one for each
variance component.
}
\description{
For two vectors of equal length representing measurements of the same
quantity by two different methods, the differences are plotted versus the
average. The limits of agreement (prediction limits for the differences) are
plotted, optionally a regression of differences of means is given too. Works
with \code{\link{Meth}} and \code{\link{MethComp}} objects too.

A plot method for the \code{"PBreg"} class object, that is a result of
Passing-Bablok regression.

When a method comparison model i fitted and stored in a \code{\link{MCmcmc}}
object, then the posterior distributions of the variance components are
plotted, in separate displays for method.
}
\details{
A plot of the relationship between the methods is produced; either a
Bland-Altman plot of the differences versus averages, or a 45 degree
rotation as a conversion between the methods. If \code{model=NULL} a simple
regression of averages on differences is made by calling \code{DA.reg}, and
the specified conversion plotted.

The function generates a series of plots, one for each method compared in
the \code{MCmcmc} object supplied (or those chosen by \code{which=}).
Therefore the user must take care to set \code{mfrow} or \code{mfcol} to
capture all the plots.
}
\examples{

data( ox )
ox <- Meth( ox )
# The simplest possible Bland-Altman plot
BA.plot( ox )

## With bells and whistles, comparing the naive and model
par( mfrow=c(2,2) )
BA.plot( ox, model=NULL, repl.conn=TRUE, col.lines="blue",
         axlim=c(0,100), diflim=c(-50,50), xaxs="i", yaxs="i",
         las=1, eqn=TRUE, dif.type="lin", pl.type="BA", sd.type="lin",
         grid=1:9*10, digits=3,font.eqn=1)
par(new=TRUE)
BA.plot( ox, model="linked", repl.conn=TRUE, col.lines="red",
         axlim=c(0,100), diflim=c(-50,50), xaxs="i", yaxs="i",
         las=1, eqn=FALSE, dif.type="lin", pl.type="BA", sd.type="lin",
        grid=1:0*10, digits=3)
BA.plot( ox, model=NULL, repl.conn=TRUE, col.lines="blue",
         axlim=c(0,100), diflim=c(-50,50), xaxs="i", yaxs="i",
         las=1, eqn=TRUE, dif.type="lin", pl.type="conv", sd.type="lin",
        grid=1:9*10, digits=3,font.eqn=1)
par(new=TRUE)
BA.plot( ox, model="linked", repl.conn=TRUE, col.lines="red",
         axlim=c(0,100), diflim=c(-50,50), xaxs="i", yaxs="i",
         las=1, eqn=FALSE, dif.type="lin", pl.type="conv", sd.type="lin",
         grid=1:9*10, digits=3)
# The same again, but now logit-transformed
BA.plot( ox, model=NULL, repl.conn=TRUE, col.lines="blue",
         axlim=c(0,100), diflim=c(-50,50), xaxs="i", yaxs="i",
         las=1, eqn=TRUE, dif.type="lin", pl.type="BA", sd.type="lin",
         grid=1:9*10, digits=3,font.eqn=1,Transform="pctlogit")
par(new=TRUE)
BA.plot( ox, model="linked", repl.conn=TRUE, col.lines="red",
         axlim=c(0,100), diflim=c(-50,50), xaxs="i", yaxs="i",
         las=1, eqn=FALSE, dif.type="lin", pl.type="BA", sd.type="lin",
         grid=1:0*10, digits=3,Transform="pctlogit")
BA.plot( ox, model=NULL, repl.conn=TRUE, col.lines="blue",
         axlim=c(0,100), diflim=c(-50,50), xaxs="i", yaxs="i",
         las=1, eqn=TRUE, dif.type="lin", pl.type="conv", sd.type="lin",
         grid=1:9*10, digits=3,font.eqn=1,Transform="pctlogit")
par(new=TRUE)
BA.plot( ox, model="linked", repl.conn=TRUE, col.lines="red",
         axlim=c(0,100), diflim=c(-50,50), xaxs="i", yaxs="i",
         las=1, eqn=FALSE, dif.type="lin", pl.type="conv", sd.type="lin",
         grid=1:9*10, digits=3,Transform="pctlogit")


  ## Model data frame generation
  a <- data.frame(x=seq(1, 30)+rnorm(mean=0, sd=1, n=30),
                  y=seq(1, 30)*rnorm(mean=1, sd=0.4, n=30))

  ## Call to PBreg
  x <- PBreg(a)
  print(x)
  par(mfrow=c(2,2))
  plot(x, s=1:4)

  ## Or the same using "Meth" object
  a <- Meth(a, y=1:2)
  x <- PBreg(a)
  print(x)
  par(mfrow=c(2,2))
  plot(x, s=1:4)

}
\references{
JM Bland and DG Altman: Statistical methods for assessing
agreement between two methods of clinical measurement, Lancet, i, 1986, pp.
307-310.

JM Bland and DG Altman. Measuring agreement in method comparison studies.
Statistical Methods in Medical Research, 8:136-160, 1999.

B Carstensen: Comparing methods of measurement: Extending the LoA by
regression. Stat Med. 2010 Feb 10;29(3):401-10.

Passing, H. and Bablok, W. (1983), A New Biometrical Procedure
for Testing the Equality of Measurements from Two Different Analytical
Methods. \emph{Journal of Clinical Chemistry and Clinical Biochemistry},
\bold{Vol 21}, 709--720
}
\seealso{
\code{\link{BA.est}}, \code{\link{DA.reg}}, \code{\link{MCmcmc}}.

\code{\link{PBreg}, \link{Deming}}.
}
\author{
Bendix Carstensen \email{bendix.carstensen@regionh.dk},
\url{https://BendixCarstensen.com}.

Michal J. Figurski \email{mfigrs@gmail.com}

Bendix Carstensen, \email{bendix.carstensen@regionh.dk}
}
\keyword{design}
\keyword{models}
