% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MCmcmc.R
\name{plot.MCmcmc}
\alias{plot.MCmcmc}
\title{Plot estimated conversion lines and formulae.}
\usage{
\method{plot}{MCmcmc}(
  x,
  axlim = range(attr(x, "data")$y, na.rm = TRUE),
  wh.cmp,
  lwd.line = c(3, 1),
  col.line = rep("black", 2),
  lty.line = rep(1, 2),
  eqn = TRUE,
  digits = 2,
  grid = FALSE,
  col.grid = gray(0.8),
  points = FALSE,
  col.pts = "black",
  pch.pts = 16,
  cex.pts = 0.8,
  ...
)
}
\arguments{
\item{x}{A \code{\link{MCmcmc}} object}

\item{axlim}{The limits for the axes in the panels}

\item{wh.cmp}{Numeric vector or vector of method names.  Which of the
methods should be included in the plot?}

\item{lwd.line}{Numerical vector of length 2. The width of the conversion
line and the prediction limits. If the second values is 0, no prediction
limits are drawn.}

\item{col.line}{Numerical vector of length 2. The color of the conversion
line and the prediction limits.}

\item{lty.line}{Numerical vector of length 2. The line types of the
conversion line and the prediction limits.}

\item{eqn}{Should the conversion equations be printed on the plot?. Defaults
to \code{TRUE}.}

\item{digits}{How many digits after the decimal point shoudl be used when
printing the conversion equations.}

\item{grid}{Should a grid be drawn? If a numerical vector is given, the grid
is drawn at those values.}

\item{col.grid}{What color should the grid have?}

\item{points}{Logical or character. Should the points be plotted. If
\code{TRUE} or \code{"repl"} paired values of single replicates are plotted.
If \code{"perm"}, replicates are randomly permuted within (item, method)
befor plotting. If \code{"mean"}, means across replicates within item,
method are formed and plotted.}

\item{col.pts}{What color should the observation have.}

\item{pch.pts}{What plotting symbol should be used.}

\item{cex.pts}{What scaling should be used for the plot symbols.}

\item{...}{Parameters to pass on. Currently not used.}
}
\value{
Nothing.  The lower part of a (M-1) by (M-1) matrix of plots is
drawn, showing the pairwise conversion lines. In the corners of each is
given the two conversion equations together with the prediction standard
error.
}
\description{
Plots the pairwise conversion formulae between methods from a
\code{\link{MCmcmc}} object.
}
\examples{

\dontrun{data( hba1c )}
\dontrun{str( hba1c )}
\dontrun{hba1c <- transform( subset( hba1c, type=="Ven" ),
                    meth = dev,
                    repl = d.ana )}
\dontrun{hb.res <- MCmcmc( hba1c, n.iter=50 )}
\dontrun{data( hba.MC )}
\dontrun{str( hba.MC )}
\dontrun{par( ask=TRUE )}
\dontrun{plot( hba.MC )}
\dontrun{plot( hba.MC, pl.obs=TRUE )}

}
\seealso{
\code{\link{MCmcmc}}, \code{\link{print.MCmcmc}}
}
\keyword{design}
\keyword{models}
\keyword{regression}
