% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MBMA_stan.R
\name{plot.MBMA_stan}
\alias{plot.MBMA_stan}
\title{Plot a dose-response plot}
\source{
This function uses \code{ggplot} function from \code{ggplot2}
R package.
}
\usage{
\method{plot}{MBMA_stan}(x = MBMA.stan, ...)
}
\arguments{
\item{x}{A \code{MBMA_stan} object.}

\item{...}{Further arguments passed to ggplot.}
}
\value{
The return value is invisible \code{NULL}.
}
\description{
Takes a \code{MBMA_stan} object which is obtained by function \code{MBMA_stan} and plot
a dose-response plot, showing observed event probabilities and the estimated dose-response
function with pointwise 95% credible intervals.
}
\examples{
\dontrun{
data('dat.Eletriptan', package = "MetaStan")
datMBMA = create_MetaStan_dat(dat = dat.Eletriptan,
                              armVars = c(dose = "d",
                                          responders = "r",
                                          sampleSize = "n"),
                              nArmsVar = "nd")

MBMA.Emax  <- MBMA_stan(data = datMBMA,
                        likelihood = "binomial",
                        dose_response = "emax",
                        Pred_doses = seq(0, 80, length.out = 11),
                        mu_prior = c(0, 100),
                        Emax_prior = c(0, 100),
                        tau_prior_dist = "half-normal",
                        tau_prior = 0.5)
plot(MBMA.Emax) + ggplot2::xlab("Doses (mg)") + ggplot2::ylab("response probabilities")

}
}
\seealso{
\code{ggplot2::ggplot}
}
\author{
Christian Roever and Burak Kuersad Guenhan
}
