% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_network.R
\name{plotly_network}
\alias{plotly_network}
\title{Plotly Log2FC Network Plot}
\usage{
plotly_network(
  metalyzer_se,
  q_value = 0.05,
  metabolite_node_size = 11,
  connection_width = 1.25,
  pathway_text_size = 20,
  pathway_width = 10,
  plot_height = 800
)
}
\arguments{
\item{metalyzer_se}{A MetAlyzer Object}

\item{q_value}{A numeric value specifying the cutoff for q-value}

\item{metabolite_node_size}{The text size of the metabolite Nodes}

\item{connection_width}{The line width of connections between metabolites}

\item{pathway_text_size}{The text size of pathway annotations}

\item{pathway_width}{The line width of pathway-specific connection coloring}

\item{plot_height}{The height of the Plot in pixel [px]}
}
\value{
plotly object
}
\description{
This function returns a list with interactive 
networkplot based on log2 fold change data.
}
\examples{
metalyzer_se <- MetAlyzer_dataset(file_path = example_mutation_data_xl())
metalyzer_se <- filterMetabolites(
  metalyzer_se,
  drop_metabolites = "Metabolism Indicators"
)
metalyzer_se <- renameMetaData(
  metalyzer_se,
  Mutant_Control = "Sample Description"
)

metalyzer_se <- calculate_log2FC(
  metalyzer_se,
  categorical = "Mutant_Control",
  impute_perc_of_min = 0.2,
  impute_NA = FALSE
)

p_network <- plotly_network(metalyzer_se, q_value = 0.05)
}
