% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_mvgmm-methods.R
\docType{methods}
\name{mr_mvgmm}
\alias{mr_mvgmm}
\alias{mr_mvgmm,MRMVInput-method}
\title{Multivariable generalized method of moments (GMM) method}
\usage{
mr_mvgmm(object, nx, ny, cor.x = NULL, robust = TRUE, alpha = 0.05, ...)

\S4method{mr_mvgmm}{MRMVInput}(object, nx, ny, cor.x = NULL, robust = TRUE, alpha = 0.05, ...)
}
\arguments{
\item{object}{An \code{MRMVInput} object.}

\item{nx}{Vector of sample sizes used to compute genetic associations with the exposure (one for each exposure).}

\item{ny}{The sample size used to compute genetic associations with the outcome.}

\item{cor.x}{Correlation matrix for exposures. Default is to assume the exposures are uncorrelated.}

\item{robust}{Indicates whether overdispersion heterogeneity is accounted for in the model. Default is TRUE.}

\item{alpha}{The significance level used to calculate the confidence interval. The default value is 0.05.}

\item{...}{Additional arguments to be passed to the optimization routines to calculate GMM estimates and overdispersion parameter.}
}
\value{
The output from the function is an \code{MVGMM} object containing:

 \item{Robust}{\code{TRUE} if overdispersion heterogeneity was included in the model, \code{FALSE} otherwise.}
 \item{Exposure}{A character vector with the names given to the exposure.}
 \item{Outcome}{A character string with the names given to the outcome.}
 \item{Correlation}{The matrix of genetic correlations if supplied. If not supplied, then an identity matrix will be returned.}
 \item{ExpCorrelation}{\code{TRUE} if an exposure correlation matrix was specified, \code{FALSE} otherwise.}
 \item{CondFstat}{A vector of conditional F-statistics (one for each exposure).}
 \item{Estimate}{A vector of causal estimates.}
 \item{StdError}{A vector of standard errors of the causal estimates.}
 \item{CILower}{The lower bounds of the causal estimates based on the estimated standard errors and the significance level provided.}
 \item{CIUpper}{The upper bounds of the causal estimates based on the estimated standard errors and the significance level provided.}
 \item{Overdispersion}{The estimate of the overdispersion parameter. If this is negative, then a value of zero is used in the method.}
 \item{Pvalue}{The p-values associated with the estimates (calculated as Estimate/StdError as per Wald test) using a normal distribution.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
 \item{Heter.Stat}{Heterogeneity statistic (Cochran's Q statistic) and associated p-value (for non-robust model only): the null hypothesis is that all genetic variants estimate the same causal parameter; rejection of the null is an indication that one or more genetic variants may be pleiotropic. If the robust option is set to \code{TRUE}, then this represents excess heterogeneity beyond the overdispersion model.}
}
\description{
The \code{mr_mvgmm} function performs multivariable Mendelian randomization via the generalized method of moments method.
}
\details{
Robust inference in two-sample multivariable Mendelian randomization using the generalized method of moments. The method accounts for overdispersion heterogeneity in genetic variant-outcome associations.
}
\examples{
mr_mvgmm(mr_mvinput(bx = cbind(ldlc, hdlc, trig), bxse = cbind(ldlcse, hdlcse, trigse),
   by = chdlodds, byse = chdloddsse), nx=rep(17723,3), ny=17723)

}
\references{
Description of the generalized method of moments: Hansen, L. P. (1982). Large sample properties of generalized method of moments estimators. Econometrica, pp.1029-1054.
}
