MaxInt.heatmap.plot <- function(Gamma_matrix, row_counts = NULL) {
  if (is.null(rownames(Gamma_matrix))) {
    rownames(Gamma_matrix) <- paste0("Row Cluster ", 1:nrow(Gamma_matrix))
  }
  if (is.null(colnames(Gamma_matrix))) {
    colnames(Gamma_matrix) <- paste0("Column Cluster ", 1:ncol(Gamma_matrix))
  }
  
  Gamma_df <- as.data.frame(Gamma_matrix, stringsAsFactors = FALSE)
  Gamma_df$RowCluster <- rownames(Gamma_matrix)
  
  df <- reshape::melt(Gamma_df, id.vars = "RowCluster")
  colnames(df) <- c("RowCluster", "ColumnCluster", "EstimatedGamma")
  
  p <- ggplot2::ggplot(df, ggplot2::aes(
    x = ColumnCluster, y = RowCluster, fill = EstimatedGamma
  )) +
    ggplot2::geom_tile(color = "white") +
    ggplot2::geom_text(ggplot2::aes(label = round(EstimatedGamma, 2)),
                       color = "black", size = 4) +
    ggplot2::scale_fill_gradient2(
      low = "blue", mid = "white", high = "red", midpoint = 0,
      name = "Estimated\nGamma"
    ) +
    ggplot2::labs(
      title = "Participant-by-Task Heatmap",
      x = "Column Clusters (Tasks)",
      y = "Row Clusters (Participants)"
    ) +
    ggplot2::theme_minimal() +
    ggplot2::theme(
      axis.text.x = ggplot2::element_text(angle = 45, hjust = 1, size = 12, face = "bold"),
      axis.text.y = ggplot2::element_text(size = 12, face = "bold"),
      plot.title = ggplot2::element_text(hjust = 0.5, face = "bold"),
      plot.subtitle = ggplot2::element_text(hjust = 0.5)
    )
  
  if (!is.null(row_counts)) {
    caption_text <- paste0(
      "Counts: ",
      paste(paste0(rownames(Gamma_matrix), " = ", row_counts, " participants"),
            collapse = "; ")
    )
    p <- p + ggplot2::labs(caption = caption_text)
  }
  
  return(p)
}

