#' Normalization of weighted linear mixed model network matrix.
#'
#' This function normalizes weighted adjacency matrix derived from lmm.
#'
#' @param matrix The adjacency matrix (to be normalized).
#' @return a normalized matrix containing values between 0 and 1.
#' @export
normalization <- function(matrix) {
  # Normalize matrix1 to the range [0, 1]
  global_min <- min(matrix)
  global_max <- max(matrix)
  normalized_matrix <- (matrix)/(global_max - global_min)

  # Set diagonal elements to 0 (optional, depending on your use case)
  diag(normalized_matrix) <- 0

  return(normalized_matrix)
}
