% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/randomstand.R
\name{randomstand}
\alias{randomstand}
\title{Generate a simple random stand of trees}
\usage{
randomstand(LAI = 2, height = 20, cwcl = 0.8, ALAC = 0.5,
  stocking = 500, edge = 10, plotsize = c(25, 25), dbh = 0.3,
  crownshape = c("ELIP", "BOX", "CONE", "PARA", "CYL"), path = "",
  maxnotrees = 25)
}
\arguments{
\item{LAI}{Leaf area index of the stand (m2 m-2)}

\item{height}{Total tree height (m)}

\item{cwcl}{The ratio of crown width to crown length}

\item{ALAC}{The ratio of tree leaf area to crown surface area (m2 m-2)}

\item{stocking}{Number of trees per hectare}

\item{edge}{An extra edge to be placed around the plot (in addition to plotsize!)}

\item{plotsize}{The size of the plot (m), as a vector (x,y)}

\item{dbh}{Trunk diameter (not relevant, just for plotting) (m)}

\item{crownshape}{One of the Maestra crown shapes}

\item{path}{Path to the directory where the Maestra files should be modified}

\item{maxnotrees}{Maximum number of target trees to be set in confile.dat (affects Maestra radiation calculations, not the plot and tree layout)}
}
\description{
Generates a stand of trees, given a LAI, stocking, and some basic allometry.
Very simple implementation that will be expanded (and eventually rolled into
Maes*).
}
\examples{
\dontrun{
# Assuming your working directory contains the Maestra input files,
randomstand()
Plotstand()
}
}

