% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotPath.R
\name{ggplotPath}
\alias{ggplotPath}
\title{\code{ggplot} paths}
\usage{
ggplotPath(
  x = "year",
  y,
  group,
  data,
  scaley = 1,
  logy = TRUE,
  legend.position,
  vlines,
  labels
)
}
\arguments{
\item{x}{name of column in \code{data} to pass as \code{x} in
\code{aes(x=.data[[x]], ...)}; default = \code{year}.}

\item{y}{name of column in \code{data} to pass as \code{y} in
\code{aes(y=.data[[y]], ...)}; must be supplied.}

\item{group}{name of grouping variable, i.e., plot a separate line for each
level of \code{group} using \code{aes(group=.data[[group]], ...)}, unless \code{group} is
missing or \code{length(unique(data[, group]))} = 1.}

\item{data}{\code{\link{data.frame}} or \code{\link[tibble:tibble]{tibble::tibble}} with columns \code{x}, \code{y}, and
\code{group}.}

\item{scaley}{factor to divide y by for plotting. Default = 1, but for data
in monetary terms, e.g., for \code{MaddisonData}, \code{y = 'gdppc'} is Gross domestic
product (GDP) per capita in 2011 dollars at purchasing power parity (PPP),
for which we typically want \code{scaley} = 1000.}

\item{logy}{logical: if \code{TRUE}, y axis is on a log scale; default = \code{TRUE}.`}

\item{legend.position}{argument passed to \code{\link[ggplot2:theme]{ggplot2::theme}}. Default depends on
\verb{nGps <- length(unique(data[, group]}: If \code{nGps} = 1, there is no legend. If
\code{nGps > 10}, \code{legend.position = 'right'}. In between, \code{legend.position} =
c(.15, .5) = center left. For alternatives, see \code{\link[ggplot2:theme]{ggplot2::theme}}.}

\item{vlines}{= locations on the \code{x} axis for vertical lines using
\code{ggplot2::geom_vline(aes(xintercept = .data[[x]]), data=vlines, ...)} with
\verb{color='grey', lty='dotted'} unless \code{color} or \code{colour} and / or \code{lty} are
available as \code{attr(x, ...)}.}

\item{labels}{= \code{\link{data.frame}} with columns \verb{x, y, label, srt, col}, where
\code{x}, \code{y}, and \code{srt} are numeric, \code{label} is character, and \code{col} are
acceptable values for \code{color} in \code{with(labels,  annotate('text', x=x, y=y, label = label, srt=srt, color=col))}.}
}
\value{
an object of class \code{\link[ggplot2:ggplot]{ggplot2::ggplot}}, which can be subsequently
edited, and whose \code{\link{print}} method produces the desired plot.
}
\description{
\code{ggplotPath} plots \code{y} vs. \code{x} (typically \code{year}) with a separate line for
each group with options for legend placement, vertical lines and labels.
}
\examples{
str(GBR_USA <- subset(MaddisonData::MaddisonData, ISO \%in\% c('GBR', 'USA')))
GBR_USA1 <- ggplotPath('year', 'gdppc', 'ISO', GBR_USA, 1000)

GBR_USA1+ggplot2::coord_cartesian(xlim=c(1500, 1850)) # for only 1500-1850 
GBR_USA1+ggplot2::coord_cartesian(xlim=c(1600, 1700), ylim=c(7, 17)) 

# label the lines
ISOll <- data.frame(x=c(1500, 1750), y=c(1.4, .7), label=c('GBR', 'USA') )
(GBR_USA2 <- ggplotPath('year', 'gdppc', 'ISO', GBR_USA, 1000, 
                        labels=ISOll) ) 
# vlines 

Vlines = c(1849, 1929, 1933, 1939, 1945)
(GBR_USA3 <- ggplotPath('year', 'gdppc', 'ISO', GBR_USA, 1000, 
                vlines=Vlines, labels=ISOll) ) 

}
\keyword{plot}
