% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMaddisonSources.R
\name{getMaddisonSources}
\alias{getMaddisonSources}
\title{Get Maddison sources}
\usage{
getMaddisonSources(
  ISO = NULL,
  plot = TRUE,
  sources = MaddisonData::MaddisonSources,
  years = MaddisonData::MaddisonYears
)
}
\arguments{
\item{ISO}{either NULL to return all sources or a character vector of ISO
codes for the countries included in the analysis or a \code{\link{data.frame}} with
the first column being the ISO codes followed by \code{yearBegin} and optionally
\code{yearEnd}.}

\item{plot}{logical indicating whether the use does nor does not include
plotting data. The Maddison project requires citing all relevant
\code{MaddisonSources} if they are plotted, denoted here by \code{plot} = TRUE. If no
data are plotted, then the Maddison project requires citing all sources only
if less than a dozen are used, denoted here by \code{plot} = FALSE, in which
case, the Maddison project requires a specific project-level citation.
Default = TRUE.}

\item{sources}{list of sources in the format of \code{\link{MaddisonSources}};
default is \code{MaddisonSources}.}

\item{years}{\code{data.frame} in the format of \code{\link{MaddisonYears}}; default is
\code{MaddisonYears}.}
}
\value{
a \code{\link[tibble:tibble]{tibble::tibble}} with 3 columns:
\describe{
\item{ISO}{3-letter ISO code for country.}
\item{years}{
character vector of years or year ranges for which \code{source} applies.
}
\item{source}{character vector of sources.}
}

in the format of \code{\link{MaddisonSources}}.
}
\description{
The
\href{https://en.wikipedia.org/wiki/Maddison_Project}{Maddison project}
collates historical economic statistics from many sources.

They have a citation policy:
CONDITIONS UNDER WHICH ALL ORIGINAL PAPERS MUST BE CITED:

a) If the data is shown in any graphical form
b) If subsets of the full dataset that include less than a dozen (12)
countries are used for statistical analysis or any other purposes

When neither a) or b) apply, then the MDP as a whole can be cited.

\code{getMaddisonSources} returns a \code{\link{data.frame}} of relevant sources for a
particular application.
}
\examples{
getMaddisonSources() # all 
getMaddisonSources(plot=FALSE) # only MDP 
getMaddisonSources('GBR') # GBR 
getMaddisonSources(names(MaddisonSources)[1:12], FALSE) # only MDP 
getMaddisonSources(data.frame(ISO=c('GBR', 'USA'), 
             yearBegin=rep(1500, 2)) ) #GBR, USA since 1500 
getMaddisonSources('AUS') # AUS: no special sources for AUS. 

}
\keyword{manip}
