% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point2side.R
\name{point_est2}
\alias{point_est2}
\title{Point estimates for two-sided M-Wright distribution}
\usage{
point_est2(x)
}
\arguments{
\item{x}{numeric vector.}
}
\value{
numeric vector
}
\description{
This provides point estimates for the shape and scale parameters.
}
\examples{
x <- rmwright2(1000, 0.7, 0.4)
point_est2(x)


}
\references{
Cahoy and Minkabo (2017). \emph{Inference for three-parameter M-Wright distributions with applications.} Model Assisted Statistics and Applications, 12(2), 115-125.
\url{https://doi.org/10.3233/MAS-170388}

Cahoy (2012). \emph{Moment estimators for the two-parameter M-Wright distribution.} Computational Statistics, 27(3), 487-497.
\url{https://doi.org/10.1007/s00180-011-0269-x}

Cahoy (2012). \emph{Estimation and simulation for the M-Wright function.}  Communications in Statistics-Theory and Methods, 41(8), 1466-1477.
\url{https://doi.org/10.1080/03610926.2010.543299}

Cahoy (2011). \emph{On the parameterization of the M-Wright function.} Far East Journal of Theoretical Statistics, 34(2), 155-164.
\url{http://www.pphmj.com/abstract/5767.htm}

Mainardi, Mura, and Pagnini (2010). \emph{The M-Wright Function in Time-Fractional Diffusion Processes: A Tutorial Survey}. Int. J. Differ. Equ., Volume 2010.
\url{https://doi.org/10.1155/2010/104505}
}
