% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rob_CovTest.R
\name{Rob_CovTest}
\alias{Rob_CovTest}
\title{Robust Test for Covariance Matrices}
\usage{
Rob_CovTest(x, group, alpha = 0.75)
}
\arguments{
\item{x}{the data matrix}

\item{group}{the grouping vector. It must be factor.}

\item{alpha}{numeric parameter controlling the size of the subsets over which the determinant is minimized. 
Allowed values are between 0.5 and 1 and the default is 0.75.}
}
\value{
a list with 1 elements:
\item{TM}{The calculated value of test statistics based on raw data}
}
\description{
Robust Test for Covariance Matrices in High Dimensional Data
}
\details{
\code{Rob_CovTest} function computes the calculated value of the test statistic for covariance matrices of two or more independent samples in high dimensional data based on the minimum regularized covariance determinant estimators.
}
\examples{

if (requireNamespace("rrcov", quietly=TRUE)) {
x1<-mvtnorm::rmvnorm(n = 8,mean = rep(0,10),sigma = diag(10))
x2<-mvtnorm::rmvnorm(n = 8,mean = rep(0,10),sigma = 2*diag(10))
x3<-mvtnorm::rmvnorm(n = 8,mean = rep(0,10),sigma = 3*diag(10))
data<-rbind(x1,x2,x3)
group_label<-c(rep(1,8),rep(2,8),rep(3,8))
Rob_CovTest(x=data, group=group_label)}
}
\references{
Bulut, H (2024). A robust permutational test to compare covariance matrices in high dimensional data. (Unpublished)
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
