% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_univariate_normality.R
\name{test_univariate_normality}
\alias{test_univariate_normality}
\title{Univariate Normality Tests}
\usage{
test_univariate_normality(data, test = c("SW", "CVM", "Lillie", "SF", "AD"))
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame with observations in rows and variables in columns.
Non-numeric columns are dropped with a warning. Each column is tested individually.}

\item{test}{A character string specifying the normality test to use.
Choices are: \code{"SW"} (Shapiro–Wilk), \code{"SF"} (Shapiro–Francia),
\code{"AD"} (Anderson–Darling), \code{"CVM"} (Cramér–von Mises), and
\code{"Lillie"} (Lilliefors test). Default is the first match from this list.}
}
\value{
A data frame with one row per variable and the following columns:
\code{Test}, the name of the test used;
\code{Variable}, the name of the tested variable;
\code{Statistic}, the test statistic;
and \code{p.value}, the associated p-value.
}
\description{
Performs one of several common univariate normality tests on each numeric variable
in a vector, matrix, or data frame.
}
\examples{
\dontrun{
data(iris)
test_univariate_normality(iris[, 1:4], test = "AD")
}

}
