% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusionMatrix.R
\name{confusionMatrix}
\alias{confusionMatrix}
\title{Confusion matrix}
\usage{
confusionMatrix(MVObj, model = "mid")
}
\arguments{
\item{MVObj}{A MUVR object (classification analysis)}

\item{model}{min, mid or max model}
}
\value{
A confusion matrix of actual vs predicted class
}
\description{
Make a confusion matrix from a MUVR object.
}
\examples{
\donttest{
data("mosquito")
data("crisp")
nRep <- 2 # Number of MUVR2 repetitions
nOuter <- 4 # Number of outer cross-validation segments
varRatio <- 0.6 # Proportion of variables kept per iteration
classModel <- MUVR2_EN(X = Xotu,
                      Y = Yotu,
                      nRep = nRep,
                      nOuter = nOuter,
                      DA = TRUE,
                      modReturn = TRUE)
confusionMatrix(classModel)
MLModel <- MUVR2(X = crispEM,
                 ML = TRUE,
                 nRep = nRep,
                 nOuter = nOuter,
                 varRatio = varRatio,
                 method = "RF",
                 modReturn = TRUE)
 confusionMatrix(MLModel)
}
}
