% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFM_consumerrisk.R
\name{MFM_consumerrisk}
\alias{MFM_consumerrisk}
\title{Consumer's Risk for Multi-state RDT with Multiple Failure Modes (MFM)}
\usage{
MFM_consumerrisk(n, cvec, pivec, Rvec)
}
\arguments{
\item{n}{RDT sample size}

\item{cvec}{Maximum allowable failures for each separate period}

\item{pivec}{Failure probability for each seperate period}

\item{Rvec}{Lower level reliability requirements for each cumulative period from the begining of the test.}
}
\value{
Probability for consumer's risk
}
\description{
Define the consumer risk function which gets the probability of passing the test when the lower level reliability requirements are not satisfied under different failure modes (for Multi-state RDT, Multiple Failure Modes).
}
\examples{
pi1 <- pi_MCSim_beta(M = 1000, seed = 10, a = 1, b = 1)
pi2 <- pi_MCSim_beta(M = 1000, seed = 10, a = 2, b = 18)
MFM_consumerrisk(n = 10, cvec = c(1, 1), pivec = cbind(pi1, pi2), Rvec = c(0.8, 0.7))
}
\seealso{
\code{\link{MFM_core}} for getting the core probability of passting the test;
\code{\link{MFM_Indicator}} for getting the binary indicator;
\code{\link{MFM_optimal_n}} for getting the optimal test sample size;

Other MSRDT for MFM functions: 
\code{\link{MFM_Indicator}()},
\code{\link{MFM_core}()},
\code{\link{MFM_optimal_n}()}
}
\concept{MSRDT for MFM functions}
