% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/center_stats.R
\name{center_stats}
\alias{center_stats}
\title{Summary of Central Tendency}
\usage{
center_stats(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A named numeric vector with values for:
\describe{
\item{mean}{Arithmetic mean}
\item{median}{Median}
\item{trim25}{25\% trimmed mean}
\item{trim10}{10\% trimmed mean}
\item{est_mode}{Estimated mode from \code{estimate_mode()}}
}
}
\description{
Computes a variety of center statistics for a numeric vector, including:
mean, median, trimmed means (10\% and 25\%), and estimated mode (via probability density function
using \code{estimate_mode()}).
}
\examples{
# Center Stats of continuous random data
set.seed(123)
x <- rnorm(1000, mean=50, sd=10)
center_stats(x)

# Center Stats of Sepal Length in iris data set
data("iris")
center_stats(iris$Sepal.Length)

}
\seealso{
\code{\link{estimate_mode}}
}
