% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeOfBlobs.R
\name{TINNIK}
\alias{TINNIK}
\title{TINNIK algorithm to infer species tree of blobs}
\usage{
TINNIK(
  genedata,
  omit = FALSE,
  epsilon = 0,
  test = "T3",
  alpha = 0.05,
  beta = 0.95,
  treemethod = fastme.bal,
  delta = 2,
  taxanames = NULL,
  plot = TRUE
)
}
\arguments{
\item{genedata}{gene tree data that may be supplied in any of 3 forms:
\enumerate{
\item as a character string giving the name of a file containing Newick gene trees,
\item as a multiPhylo object containing the gene trees, or
\item as a table of quartets on the gene trees, as produced by a previous call to
\code{TINNIK} or \code{quartetTableResolved}, which has columns only for taxa, resolved quartet counts,
and possibly p_T3, p_cut, and p_star
}}

\item{omit}{\code{FALSE} to treat unresolved quartets as 1/3 of each resolution;
\code{TRUE} to discard unresolved quartet data; ignored if gene tree data given as quartet table}

\item{epsilon}{minimum for branch lengths to be treated as non-zero; ignored if gene tree data given as quartet table}

\item{test}{a hypothesis test to perform, either "cut" or "T3" (default)}

\item{alpha}{a value or vector of significance levels for judging p-values for test specified by "test";
testing a null hypothesis of no hybridization vs. an alternative of hybridization, for each quartet;  a smaller value applies
a less conservative test for a tree (more trees), hence a stricter requirement for deciding in favor of hybridization (fewer reticulations)}

\item{beta}{a value or vector of significance levels for judging p-values testing
a null hypothesis of a star tree (polytomy) for each quartet vs. an alternative of anything else; a smaller value applies a less conservative
test for a star tree (more polytomies), hence a stricter requirement for deciding in favor of a resolved tree or network;
if vectors, \code{alpha} and \code{beta} must have the same length}

\item{treemethod}{a function implementing a method of tree inference from a distance table,
e.g. the ape package's fastme.bal or nj}

\item{delta}{a minimum edge length to retain in tree of blobs (see \insertCite{ABMR24}{MSCquartets} for related theory); shorter edges are collapsed}

\item{taxanames}{if \code{genedata} is a file or a multiPhylo object, a vector of a subset
of the taxa names on the gene trees
to be analyzed, if \code{NULL} all taxa on the first gene tree are used; if \code{genedata}
is a quartet table, this argument is ignored and all taxa in the table are used}

\item{plot}{\code{TRUE} produces simplex plots of hypothesis test results and plots the tree of blobs \code{FALSE} omits plots}
}
\value{
\code{output} (returned invisibly), with \code{output$ToB} the TINNIK tree of blobs, \code{output$pTable}
the table of quartets and p-values for judging fit to the MSC on quartet
trees, and \code{output$Bquartets} a TRUE/FALSE indicator vector of B-quartets; if \code{alpha, beta} are vectors, \code{output$ToB} is a vector of trees;
the table can be used as input to \code{TINNIK} or \code{TINNIKdist} with new choices of \code{alpha, beta}, without re-tallying quartets on
gene trees
}
\description{
Apply the TINNIK algorithm of \insertCite{ABMR24;textual}{MSCquartets} (see also \insertCite{ABMR22;textual}{MSCquartets})
to infer a tree of blobs for the species network from a collection of gene trees,
under the network multispecies coalescent (NMSC) model.
}
\details{
This function
\enumerate{
\item counts displayed quartets across gene trees to form quartet count concordance factors (qcCFs),
\item applies appropriate hypothesis tests to judge qcCFs as representing putative hybridization,
resolved trees, or unresolved (star) trees using \code{alpha} and \code{beta} as significance levels,
\item produces a simplex plot showing results of the hypothesis tests for all qcCFs
\item computes the appropriate TINNIK distance table, and infers the tree of blobs from the distance.
}

A call of \code{TINNIK} with \code{genedata} given as a table previously output from \code{TINNIK} is
equivalent to a call of \code{TINNIKdist} followed by tree construction from the distance table.
If \code{genedata} is a
table previously output from \code{quartetTableResolved}
which lacks columns of p-values for hypothesis tests, these will be appended to the table output by \code{TINNIK}.
This table must contain a row with quartet counts for every 4 taxon set.

If plots are produced, there are 2 simplex plots: The first shows the hypothesis test results,
and the second shows
inferred B-quartets and T-quartets. In both,
each point in the simplex plot corresponds to an empirical quartet concordance factor,
color-coded to represent test or inference results.

In general, \code{alpha} should be chosen to be small and \code{beta}
to be large so that most quartets are interpreted as resolved trees. More quartets judges to have
either blob or unresolved relationships will lead to a less resolved blob tree.

Usually, an initial call to \code{TINNIK} will not give a good analysis, as values
of \code{alpha} and \code{beta} are likely to need some adjustment based on inspecting the data. Saving the returned
table of test results from \code{TINNIK} will allow for the results of the time-consuming computation of qcCFs to be
saved, along with p-values,
for input to further calls of \code{TINNIK} with new choices of \code{alpha} and \code{beta}.

See the documentation for \code{\link{TINNIKdist}} for an explanation of a small, rarely noticeable,
stochastic element of the algorithm.

For data sets of many gene trees, user time may be reduced by using parallel code for
counting displayed quartets. See \code{\link{quartetTableParallel}}.
}
\examples{
data(pTableYeastRokas)
out=TINNIK(pTableYeastRokas, alpha=.01, beta=.05)

}
\references{
\insertRef{ABMR22}{MSCquartets}

\insertRef{ABMR24}{MSCquartets}
}
\seealso{
\code{\link{quartetTable}}, \code{\link{quartetTableParallel}}, \code{\link{quartetTableDominant}}, \code{\link{quartetCutTestInd}},\code{\link{quartetTreeTestInd}},
\code{\link{quartetStarTestInd}}, \code{\link{TINNIKdist}}, \code{\link{quartetTestPlot}}, \code{\link{pvalHist}}
}
