% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cluster_sequences.R
\name{get_cluster_sequences}
\alias{get_cluster_sequences}
\title{Extract sequences of length k within clusters}
\usage{
get_cluster_sequences(
  dt,
  cl_col = "cl",
  id_col = "link_id",
  event_col = "reg",
  aos_col = "aos",
  cens = "cens",
  k = 2
)
}
\arguments{
\item{dt}{A \code{data.table} or data.frame containing the data in a long format.}

\item{cl_col}{Name of the column containing cluster labels.}

\item{id_col}{Name of the column identifying individual trajectories (e.g. patient ID).}

\item{event_col}{Name of the column containing ordered events (e.g. diagnoses, prescriptions).}

\item{aos_col}{Name of the column containing age at onset.}

\item{cens}{Code indicating censoring.}

\item{k}{Integer specifying the sequence length (recomended 2).}
}
\value{
A named list of data frames, each containing sequences of length \code{k} observed in a given cluster.
}
\description{
For each cluster, extract all sequence of length \code{k} from the ordered observations grouped by individual
IDs. Returns a list of sequences per cluster.
}
\references{
Delord M, Douiri A (2025) \url{doi:10.1186/s12874-025-02476-7}
}
\seealso{
\code{\link[arulesSequences]{cspade}} in the \pkg{arulesSequences} package for sequential pattern
mining using the SPADE algorithm.
}
\author{
Marc Delord
}
\concept{Sequence analysis}
\keyword{Censored}
\keyword{matrix}
\keyword{state}
