#'Method of Moments Estimation of Normal distribution
#'@description function to get the method of moment estimate(s) of normal distribution
#'@param data A numeric vector.
#'@param unknown A character string specifying which parameter is (are) unknown to the user.
#'@param mean,sd	mean and standard deviation of the distribution of the normal distribution, sd must be strictly positive.
#'@param plot logical which controls whether the histogram of the data along with the density curve of the theoretical normal distribution with the estimated parameters.
#'@param curvecol color of the theoretical density curve
#'@param ... additional plotting parameters
#'@importFrom stats dnorm sd
#'@importFrom graphics hist curve
#'@return the estimated parameters by the method of moments of the data assuming the underlying distribution is normal distribution
#'@examples
#'norm_est(rnorm(1000),unknown="mean",sd=1)#mean unknown, but sd known
#'norm_est(rnorm(1000),unknown="sd",mean=0)#sd unknown, but mean known
#'norm_est(rnorm(1000),unknown="both")#both will be estimated
#'@export
norm_est=function(data,unknown=c("mean","sd","both"),mean=NULL,sd=NULL,plot=TRUE,curvecol="red",...)
{
  unknown=match.arg(unknown)
  n=length(data)
  avg=mean(data)
  s.dev=(sd(data)*(n+1))/n
  if(unknown=="mean") mean=avg
  if(unknown=="sd") sd=s.dev
  if(unknown=="both")
  {
    sd= s.dev
    mean= avg
  }
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dnorm(x,mean=mean,sd=sd),add=TRUE,col=curvecol)
  }
  output=list(mean,sd)
  names(output)=c("mean","sd")
  return(output)
}
