% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterFeatures.R
\name{filterFeatures}
\alias{filterFeatures}
\title{Filter features of input table according to prevalence and/or
abundance}
\usage{
filterFeatures(x, prev = NA, abund = NA)
}
\arguments{
\item{x}{A matrix or data frame.}

\item{prev}{A numeric ranging from 0 to 1, the minimum prevalence of features
to be retained. If set to NA, means no need to filter prevalence.}

\item{abund}{A numeric greater than 0, the minimum abundance (mean) of
features to be retained. If set to NA, means no need to filter abundance.}
}
\value{
A filtered feature table will be returned.
}
\description{
Filter features of input table according to prevalence and/or abundance.
}
\examples{
data(train_metag)
d <- filterFeatures(train_metag, prev = 0.8)
dim(train_metag)
dim(d)
}
