% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMINP_train.R
\name{MMINP.train}
\alias{MMINP.train}
\title{Train MMINP model using paired microbial features and metabolites data}
\usage{
MMINP.train(
  metag,
  metab,
  n = 1:3,
  nx = 0:3,
  ny = 0:3,
  seed = 1234,
  compmethod = NULL,
  nr_folds = 3,
  nr_cores = 1,
  rsignif = 0.4,
  psignif = 0.05,
  recomponent = FALSE
)
}
\arguments{
\item{metag}{Training data of sequence features' relative abundances.
Must have the exact same rows (subjects/samples) as \code{metab}.}

\item{metab}{Training data of metabolite relative abundances.
Must have the exact same rows (subjects/samples) as \code{metag}.}

\item{n}{Integer. Number of joint PLS components. Must be positive.
More details in \code{\link[OmicsPLS]{crossval_o2m}} and
\code{\link[OmicsPLS]{crossval_o2m_adjR2}}.}

\item{nx}{Integer. Number of orthogonal components in \code{metag}. Negative
values are interpreted as 0.
More details in \code{\link[OmicsPLS]{crossval_o2m}} and
\code{\link[OmicsPLS]{crossval_o2m_adjR2}}.}

\item{ny}{Integer. Number of orthogonal components in \code{metab}. Negative
values are interpreted as 0.
More details in \code{\link[OmicsPLS]{crossval_o2m}} and
\code{\link[OmicsPLS]{crossval_o2m_adjR2}}.}

\item{seed}{a random seed to make the analysis reproducible, default is 1234.}

\item{compmethod}{A character string indicating which Cross-validate
procedure of O2PLS is to be used for estimating components, must be one of
"NULL", "cvo2m" or "cvo2m.adj". If set to "NULL", depends on the features
number.}

\item{nr_folds}{Positive integer. Number of folds to consider.
Note: \code{kcv=N} gives leave-one-out CV. Note that CV with less than two
folds does not make sense.
More details in \code{\link[OmicsPLS]{crossval_o2m}} and
\code{\link[OmicsPLS]{crossval_o2m_adjR2}}.}

\item{nr_cores}{Positive integer. Number of cores to use for CV. You might
want to use \code{\link{detectCores}()}. Defaults to 1.
More details in \code{\link[OmicsPLS]{crossval_o2m}} and
\code{\link[OmicsPLS]{crossval_o2m_adjR2}}.}

\item{rsignif}{A numeric ranging from 0 to 1, the minimum correlation
coefficient of features which considered as well-predicted features.}

\item{psignif}{A numeric ranging from 0 to 1, the maximum adjusted p value of
features which considered as well-predicted features.}

\item{recomponent}{Logical, whether re-estimate components or not during each
iteration.}
}
\value{
A list containing
\item{model}{O2PLS model}
\item{trainres}{Final correlation results between predicted and measured
metabolites of training samples}
\item{components}{Components number. If \code{recomponent = TRUE}, the
components number is the result of last estimation.}
\item{re_estimate}{Re-estimate information, i.e. whether re-estimate
components or not during each iteration}
\item{trainnumb}{Iteration number}
}
\description{
This function contains three steps.
Step1, Build an O2-PLS model and use it to predict metabolites profile;
Step2, Compare predicted and measured metabolites abundances, then filter
those metabolites which predicted poorly (i.e. metabolites of which
correlation coefficient less than \code{rsignif} or adjusted pvalue greater
than \code{psignif}.);
Step3, (iteration) Re-build O2-PLS model until all reserved metabolites are
well-fitted.
}
\examples{
data(test_metab)
data(test_metag)
a <- MMINP.preprocess(test_metag[, 1:20], normalized = FALSE)
b <- MMINP.preprocess(test_metab[, 1:20], normalized = FALSE)
mminp_model <- MMINP.train(metag = a,
                           metab = b,
                           n = 3:5, nx = 0:3, ny = 0:3,
                           nr_folds = 2, nr_cores = 1)
length(mminp_model$trainres$wellPredicted)
}
