% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpca.R
\name{fpca}
\alias{fpca}
\title{Functional principal components analysis by smoothed covariance}
\usage{
fpca(
  Y = NULL,
  ydata = NULL,
  Y.pred = NULL,
  argvals = NULL,
  argvals_obs = FALSE,
  argvals_pred = seq(0, 1, by = 0.01),
  random.int = FALSE,
  nbasis = 10,
  nbasis_cov = nbasis,
  bs_cov = "symm",
  pve = 0.99,
  npc = NULL,
  useSymm = FALSE,
  makePD = FALSE,
  center = TRUE,
  cov.est.method = 1,
  integration = "trapezoidal"
)
}
\arguments{
\item{Y, ydata}{the user must supply either \code{Y}, a matrix of functions
observed on a regular grid, or a data frame \code{ydata} representing
irregularly observed functions. See Details.}

\item{Y.pred}{if desired, a matrix of functions to be approximated using
the FPC decomposition.}

\item{argvals}{the argument values of the function evaluations in \code{Y},
defaults to a equidistant grid from 0 to 1.}

\item{argvals_obs}{Should the timepoints of the original observations be
used to evaluate the FPCs. Defaults to FALSE.}

\item{argvals_pred}{Vector of timepoints on which to evaluate the FPCs.
Defaults to a sequence from 0 to 1.}

\item{random.int}{If \code{TRUE}, the mean is estimated by
\code{\link[gamm4]{gamm4}} with random intercepts. If \code{FALSE} (the
default), the mean is estimated by \code{\link[mgcv]{gam}} treating all the
data as independent.}

\item{nbasis}{number of B-spline basis functions used for estimation of the
mean function.}

\item{nbasis_cov}{number of basis functions used for the bivariate
smoothing of the covariance surface.}

\item{bs_cov}{type of spline for the bivariate smoothing of the covariance
surface. Default is symmetric fast covariance smoothing proposed by
Cederbaum.}

\item{pve}{proportion of variance explained: used to choose the number of
principal components.}

\item{npc}{prespecified value for the number of principal components (if
given, this overrides \code{pve}).}

\item{useSymm}{logical, indicating whether to smooth only the upper
triangular part of the naive covariance (when \code{cov.est.method==2}).
This can save computation time for large data sets, and allows for
covariance surfaces that are very peaked on the diagonal.}

\item{makePD}{logical: should positive definiteness be enforced for the
covariance surface estimate?}

\item{center}{logical: should an estimated mean function be subtracted from
\code{Y}? Set to \code{FALSE} if you have already demeaned the data using
your favorite mean function estimate.}

\item{cov.est.method}{covariance estimation method. If set to \code{1}
(the default), a one-step method that applies a bivariate smooth to the
\eqn{y(s_1)y(s_2)} values. This can be very slow. If set to \code{2}, a two-step
method that obtains a naive covariance estimate which is then smoothed.}

\item{integration}{quadrature method for numerical integration; only
\code{'trapezoidal'} is currently supported.}
}
\value{
An object of class \code{fpca} containing:
\item{Yhat}{FPC approximation (projection onto leading components)
of \code{Y.pred} if specified, or else of \code{Y}.}
\item{Y}{the observed data}\item{scores}{\eqn{n
\times npc} matrix of estimated FPC scores.} \item{mu}{estimated mean
function (or a vector of zeroes if \code{center==FALSE}).} \item{efunctions
}{\eqn{d \times npc} matrix of estimated eigenfunctions of the functional
covariance, i.e., the FPC basis functions.} \item{evalues}{estimated
eigenvalues of the covariance operator, i.e., variances of FPC scores.}
\item{npc }{number of FPCs: either the supplied \code{npc}, or the minimum
number of basis functions needed to explain proportion \code{pve} of the
variance in the observed curves.} \item{argvals}{argument values of
eigenfunction evaluations} \item{sigma2}{estimated measurement error
variance.} \item{diag.var}{diagonal elements of the covariance matrices for
each estimated curve.} \item{VarMats}{a list containing the estimated
covariance matrices for each curve in \code{Y}.} \item{crit.val}{estimated
critical values for constructing simultaneous confidence intervals.}
}
\description{
Decomposes functional observations using functional principal components
analysis. A mixed model framework is used to estimate scores and obtain
variance estimates. This function is a slightly adapted copy of the
\code{\link[refund]{fpca.sc}} function in package \code{refund}
(version 0.1-30).
}
\details{
This function computes a FPC decomposition for a set of observed curves,
which may be sparsely observed and/or measured with error. A mixed model
framework is used to estimate curve-specific scores and variances.

FPCA via kernel smoothing of the covariance function, with the diagonal
treated separately, was proposed in Staniswalis and Lee (1998) and much
extended by Yao et al. (2005), who introduced the 'PACE' method.
\code{fpca.sc} uses penalized splines to smooth the covariance function, as
developed by Di et al. (2009) and Goldsmith et al. (2013). This
implementation uses REML and Cederbaum et al. (2018) for smoothing the
covariance function.

The functional data must be supplied as either \itemize{ \item an \eqn{n
\times d} matrix \code{Y}, each row of which is one functional observation,
with missing values allowed; or \item a data frame \code{ydata}, with
columns \code{'.id'} (which curve the point belongs to, say \eqn{i}),
\code{'.index'} (function argument such as time point \eqn{t}), and
\code{'.value'} (observed function value \eqn{Y_i(t)}).}
}
\references{
Cederbaum, J. Scheipl, F. and Greven, S. (2018). Fast symmetric
additive covariance smoothing. \emph{Computational Statistics & Data
Analysis}, 120, 25--41.

Di, C., Crainiceanu, C., Caffo, B., and Punjabi, N. (2009).
Multilevel functional principal component analysis. \emph{Annals of Applied
Statistics}, 3, 458--488.

Goldsmith, J., Greven, S., and Crainiceanu, C. (2013). Corrected confidence
bands for functional data using principal components. \emph{Biometrics},
69(1), 41--51.

Staniswalis, J. G., and Lee, J. J. (1998). Nonparametric regression
analysis of longitudinal data. \emph{Journal of the American Statistical
Association}, 93, 1403--1418.

Yao, F., Mueller, H.-G., and Wang, J.-L. (2005). Functional data analysis
for sparse longitudinal data. \emph{Journal of the American Statistical
Association}, 100, 577--590.
}
\author{
Jeff Goldsmith \email{jeff.goldsmith@columbia.edu}, Sonja Greven
\email{sonja.greven@stat.uni-muenchen.de}, Lan Huo
\email{Lan.Huo@nyumc.org}, Lei Huang \email{huangracer@gmail.com}, and
Philip Reiss \email{phil.reiss@nyumc.org}, Alexander Volkmann
}
