% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{qc_in_range}
\alias{qc_in_range}
\title{Check that MIC is within QC range}
\usage{
qc_in_range(
  measurement,
  strain,
  ab,
  ignore_na = TRUE,
  guideline = "EUCAST",
  year = "2023"
)
}
\arguments{
\item{measurement}{measured QC MIC}

\item{strain}{control strain identifier (usually ATCC)}

\item{ab}{antibiotic name (will be coerced to AMR::as.ab)}

\item{ignore_na}{ignores NA (returns TRUE)}

\item{guideline}{Guideline to use (EUCAST or CLSI)}

\item{year}{Guideline year (version)}
}
\value{
logical vector
}
\description{
Check whether MIC values are within acceptable range for
quality control (QC). Every MIC experiment should include a control strain
with a known MIC. The results of the experiment are only valid if the control
strain MIC falls within the acceptable range. This function checks whether
an MIC result is within the acceptable range given: 1) a control strain
(usually identified as an ATCC or NCTC number), 2) an antibiotic name, and 3)
a guideline (EUCAST or CLSI). The acceptable range is defined by 'QC_table',
which is a dataset which is loaded with this package.

The source of the QC values is the WHONET QC Ranges and Targets available from
the 'Antimicrobial Resistance Test Interpretation Engine' (AMRIE) repository:
https://github.com/AClark-WHONET/AMRIE
}
\examples{
qc_in_range(AMR::as.mic(0.5), 25922, "GEN") == TRUE
qc_in_range(AMR::as.mic(8.0), 25922, "GEN") == FALSE
}
\references{
O’Brien TF, Stelling JM. WHONET: An Information System for Monitoring
Antimicrobial Resistance. Emerg Infect Dis. 1995 Jun;1(2):66–66.
}
